package Freenet.contrib.storeplot;

import java.awt.*;

public class StoreGraph extends Component {
    
    protected PlotBar b;
    float scale;

    public StoreGraph(PlotBar b) {
	this.b=b;
	int max=0;
	for (int i=0; i<1024; i++) 
	    max=Math.max(max, b.getPlot(i));
	scale=(float)(200.0/max);
	setBackground(Color.white);
    }

    public Dimension getPreferredSize() {
	return new Dimension(1060,200);
    }

    public void paint(Graphics g) {
	for (int i=0; i<200; i+=20) {
	    g.setColor(Color.blue);
	    g.drawString(Integer.toString((int)(i/scale)),1024,200-i);
	    g.drawLine(0,200-i,1024,200-i);
	}

	g.setColor(Color.black);
	for (int i=0; i<1024; i++) {
	    int p=b.getPlot(i);
	    g.drawRect(i, 200-(int)(p*scale), 1,1);
	}

	int yp=200;

	for (int i=2; i<1022; i+=5) {
	    int a=(b.getPlot(i-2) + b.getPlot(i-1) +
		   b.getPlot(i) + b.getPlot(i+1) + b.getPlot(i+2))/5;
	    int p=200-(int)(a*scale);
	    g.drawLine(i-5, yp, i, p);
	    yp=p;
	}
    }
}

