package Freenet.contrib.xmlrpc;

import java.util.*;
import Freenet.client.*;
import Freenet.*;
import Freenet.support.*;
import java.io.*;

public class LocalChunkedClient implements ChunkedClient
{
  static final public String apiVersion = "0.1";
  Hashtable transfers=new Hashtable();
  Random random=new Random();
  int chunkSize=2048;
  Params params;

  public LocalChunkedClient(Params p)
  {
    params=p;
    Core.init(params);
    chunkSize=Core.bufferSize;
  }

  public int startRequest(String key, int htl) throws Exception
  {
    params.setParam("htl", new Integer(htl).toString());
    SimplifiedClient sc=new SimplifiedClient(params);
    int r=random.nextInt();

    Pair p=null;
    try { p = sc.getMetadata(key); }
    catch(Exception e)
    {
      transfers.put(new Integer(r), new Transfer(null, null, FAILED));
      return r;
    }

    transfers.put(new Integer(r), new Transfer((Bucket)p.first, (Bucket)p.last, TRANSFERRING));
    return r;
  }

  public int startInsert(String key, int htl) throws Exception
  {
    int r=random.nextInt();
    Bucket b=new FileBucket();
    Bucket m=new FileBucket();
    Transfer transfer=new Transfer(b, m, TRANSFERRING);
    transfer.setKey(key);
    transfer.setHtl(htl);
    transfers.put(new Integer(r), transfer);
    return r;
  }

  public int getNumberOfChunks(int id) throws Exception
  {
    Transfer transfer=(Transfer)transfers.get(new Integer(id));
    if(transfer==null) System.out.println("Bad id.");
    Bucket b = transfer.data;
    System.out.println(b.size());
    System.out.println(b.size()/chunkSize);
    int numChunks = (int)(b.size()/chunkSize); // Can't have more than MAX_INT chunks. XML-RPC doesn't support long values.
    if((b.size() % chunkSize) != 0) numChunks++;
    return numChunks;
  }

  public byte[] nextChunk(int id) throws Exception
  {
    Transfer transfer=(Transfer)transfers.get(new Integer(id));
    if(transfer==null) System.out.println("Bad id.");
    Bucket b = transfer.data;
    InputStream is=b.getInputStream();
    byte[] barr=new byte[chunkSize];
    int num=is.read(barr);
    if(num==-1)
    {
      transfer.status=DONE;
      transfers.put(new Integer(id), transfer);
      throw new EOFException();
    }
    if(num==barr.length) return barr;

    return new String(barr, 0, num).getBytes();
  }

  public void putChunk(int id, byte[] chunk) throws Exception
  {
    Transfer transfer=(Transfer)transfers.get(new Integer(id));
    if(transfer==null) System.out.println("Bad id.");
    Bucket b = transfer.data;
    OutputStream os=b.getOutputStream();
    os.write(chunk);
  }

  public void endInsert(int id) throws Exception
  {
    Transfer transfer=(Transfer)transfers.get(new Integer(id));
    if(transfer==null) System.out.println("Bad id.");
    Bucket b = transfer.data;
    Bucket m = transfer.meta;
    String uri=transfer.key;
    int htl=transfer.htl;
    params.setParam("htl", new Integer(htl).toString());
    SimplifiedClient sc=new SimplifiedClient(params);
    OutputStream os=b.getOutputStream();
    os.close();
    transfer.status=INSERTING;
    transfers.put(new Integer(id), transfer);
    try { sc.put(uri, b, m); }
    catch(Exception e)
    {
      transfers.put(new Integer(id), new Transfer(null, null, FAILED));
    }    
    transfer.status=DONE;
    transfers.put(new Integer(id), transfer);
  }

  public int getStatus(int id)
  {
    Transfer transfer=(Transfer)transfers.get(new Integer(id));
    if(transfer==null) System.out.println("Bad id");
    return transfer.status;
  }

  private class Transfer
  {
    public Bucket data;
    public Bucket meta;
    public int status;
    public String key;
    public int htl;

    public Transfer(Bucket d, Bucket m, int s)
    { data=d; meta=m; status=s; }
    public void setHtl(int h) {htl=h;}
    public void setKey(String k) {key=k;}
  }
}
