package Freenet.contrib.xmlrpc;

import java.util.*;
import Freenet.client.*;
import Freenet.*;
import Freenet.support.*;
import java.io.*;

public class LocalSimpleClient implements SimpleClient
{
    int chunkSize=16384;
    Params params;
    Logger l = null;
    SimplifiedClient sc= null;

  public LocalSimpleClient(Params p)
  {
    params=p;
    //    Core.init(params);
    sc = new SimplifiedClient(params);
    chunkSize=params.getint("chunkSize", 16384);
    l = Core.logger;
  }

    public byte[] getFile(String key, int htl) throws Exception {
	log("Got request for " + key, Logger.DEBUG);
	log("HTL set to " + htl, Logger.DEBUG);

	sc.setHtl(htl);
	PipedBucket data = new PipedBucket();
	FileBucket meta = new FileBucket();
	sc.getMetadata(key, data, meta);
	log("Got data.", Logger.DEBUG);

	InputStream is=data.getInputStream();

	byte[] buff = new byte[chunkSize];
	byte[] out = new byte[chunkSize];

	int total = 0;
	int cb = 0;

	while (true) {
	    cb = is.read(buff);
	    if (cb == -1) {
		break;
	    }
	    if (total + cb > out.length) {
		out = resize(out, total + cb);
	    }
	    System.arraycopy(buff, 0, out, total, cb);
	    total += cb;
	}
	is.close();
	log("Done reading.", Logger.DEBUG);
	return subarray(out, total);
    }

  public void putFile(String uri, int htl, byte[] data) throws Exception
  {
    params.setParam("htl", new Integer(htl).toString());
    SimplifiedClient sc=new SimplifiedClient(params);
    Bucket b=new FileBucket();
    OutputStream os=b.getOutputStream();
    os.write(data);
    os.close();
    sc.put(uri, b, new FileBucket());    
  }
    
    protected void log(String msg, int priority) {
	if (l != null) {
	    l.log(this, msg, priority);
	}
    }
    
    protected byte[] resize(byte[] in, int newSize) {
	int realSize = chunkSize;
	while (realSize < newSize) {
	    realSize *= 2;
	}
	byte[] result = new byte[realSize];
	System.arraycopy(in, 0, result, 0, in.length);
	return result;
    }

    protected byte[] subarray(byte[] in, int size) {
	byte[] result = new byte[size];
	System.arraycopy(in, 0, result, 0, size);
	return result;
    }
}
