package Freenet.contrib.xmlrpc;

import java.util.*;
import Freenet.client.*;
import Freenet.*;
import Freenet.support.*;
import java.io.*;
import java.net.*;

public class LocalStreamingClient implements StreamingClient
{
  static final public String apiVersion = "0.1";
  Hashtable ports=new Hashtable();
  Hashtable connections=new Hashtable();
  Hashtable transfers=new Hashtable();
  Random random=new Random();
  int chunkSize=2048;
  Params params;

  public LocalStreamingClient(Params p)
  {
    params=p;
    Core.init(params);
    chunkSize=Core.bufferSize;
  }

  public int getPort() throws Exception
  {
    ServerSocket sock=new ServerSocket(0);
    int port=sock.getLocalPort();
    ports.put(new Integer(port), sock);
    Transfer transfer=new Transfer(null, null, LISTENING);
    transfers.put(new Integer(port), transfer);
    new Listener(sock).start();
    return port;
  }

  public int startRequest(int port, String key, int htl) throws Exception
  {
System.out.println(ports);
System.out.println(connections);
System.out.println(transfers);
    params.setParam("htl", new Integer(htl).toString());
    SimplifiedClient sc=new SimplifiedClient(params);

    Transfer transfer=(Transfer)transfers.get(new Integer(port));
    Bucket data=new PipedBucket();
    Bucket meta=new FileBucket();
    int size=-1;
    try { size=(int)sc.getMetadata(key, data, meta); } // XML-RPC doesn't support long ints.
    catch(Exception e)
    {
      transfer.data=null;
      transfer.meta=null;
      transfer.status=FAILED;
      transfers.put(new Integer(port), transfer);
      return FAILED;
    }
    transfer.data=data;
    transfer.meta=meta;
    transfer.status=TRANSFERRING;
    transfer.setSize(size);
    transfers.put(new Integer(port), transfer);

    new Pump(port).start();
    return TRANSFERRING;
  }

  public int setFileSize(int port, int size) throws Exception
  {
System.out.println("set size");
    synchronized(transfers)
    {
      Transfer transfer=(Transfer)transfers.get(new Integer(port));
      if(transfer==null) System.out.println("Bad id");
      transfer.setSize(size);
      transfers.put(new Integer(port), transfer);
      if(transfer.insert)
        System.out.println(transfers);
      return transfer.status;
    }
  }

  public int getFileSize(int port) throws Exception
  {
    Transfer transfer=(Transfer)transfers.get(new Integer(port));
    if(transfer==null) System.out.println("Bad id");
    return transfer.size;
  }

  public String getKey(int port) throws Exception
  {
    Transfer transfer=(Transfer)transfers.get(new Integer(port));
    return transfer.key;
  }

  public int startInsert(int port, String key, int htl) throws Exception
  {
    Bucket b=new FileBucket();
    Bucket m=new NullBucket();
    Transfer transfer=(Transfer)transfers.get(new Integer(port));
    transfer.data=b;
    transfer.meta=m;
    transfer.insert=true;
    transfer.status=TRANSFERRING;
    transfer.setHtl(htl);
    transfer.setKey(key);
    transfers.put(new Integer(port), transfer);
    new Suck(port).start();
    return transfer.status;
  }

  public int endInsert(int port) throws Exception
  {
System.out.println("endInsert");
    Transfer transfer=(Transfer)transfers.get(new Integer(port));
    Bucket b=transfer.data;
    Bucket m=transfer.meta;
    String key=transfer.key;
    int htl=transfer.htl;
    params.setParam("htl", new Integer(htl).toString());
    SimplifiedClient sc=new SimplifiedClient(params);
    System.out.println("b.size(): "+b.size());
    b.getOutputStream().close();
    transfer.status=INSERTING;
    transfers.put(new Integer(port), transfer);
    try { key=sc.put(key, b, m); }
    catch(Exception e)
    {
System.out.println("failed");
      e.printStackTrace();
      transfer.status=FAILED;
      transfers.put(new Integer(port), transfer);
      return FAILED;
    }

System.out.println("success");
    transfer.key=key;
    transfer.status=DONE;
    transfers.put(new Integer(port), transfer);
    return DONE;
  }

  public int getStatus(int id)
  {
    Transfer transfer=(Transfer)transfers.get(new Integer(id));
    if(transfer==null) System.out.println("Bad id");
    return transfer.status;
  }

  private class Transfer
  {
    public boolean insert=false;
    public Bucket data;
    public Bucket meta;
    public int status;
    public int size=-1;
    public int transferred=0;
    public int htl;
    public String key;

    public Transfer(Bucket d, Bucket m, int s)
    { data=d; meta=m; status=s; }

    public String toString() {return "Transfer: "+transferred+"/"+size;}

    public void setSize(int s) {size=s;}
    public void setHtl(int h) {htl=h;}
    public void setKey(String k) {key=k;}
    public void setTransferred(int t) {transferred=t;}
  }

  private class Listener extends Thread
  {
    ServerSocket sock;

    public Listener(ServerSocket ss)
    { 
      sock=ss;
    }

    public void run()
    {
      Socket s=null;
      try { s=sock.accept(); }
      catch(Exception e)
      {
        Transfer transfer=new Transfer(null, null, FAILED);
        transfers.put(new Integer(sock.getLocalPort()), transfer);
        return;
      }

      connections.put(new Integer(sock.getLocalPort()), s);
      ports.remove(new Integer(sock.getLocalPort()));
      Transfer transfer=new Transfer(null, null, WAITING);
      transfers.put(new Integer(sock.getLocalPort()), transfer);
    }
  }

  private class Pump extends Thread
  {
    Integer port;

    public Pump(int i) { port=new Integer(i); }
    public void run()
    {
      Transfer transfer=(Transfer)transfers.get(port);
      Bucket data=transfer.data;
      Bucket meta=transfer.meta;

      try
      {
        Socket sock=(Socket)connections.get(port);
        InputStream in=getIn(data, sock);
        OutputStream out=getOut(data, sock);
        pump(in, out);
        out.close();
        sock.close();
        connections.remove(port);
        transfer=(Transfer)transfers.get(port);
        if(transfer.insert)
        {
          if(transfer.size==transfer.transferred) endInsert(port.intValue());
          else throw new IOException();
        }
      }
      catch(Exception e)
      {
        System.out.println("size: "+transfer.size);
        System.out.println("transferred: "+transfer.transferred);
        transfer.status=FAILED;
        transfers.put(port, transfer);
      }
    }

    public void pump(InputStream in, OutputStream out) throws IOException
    {
      BufferedInputStream bis=new BufferedInputStream(in);
      byte[] barr=new byte[Core.bufferSize];

      int b=bis.read(barr);
      while(b!=-1)
      {
        out.write(barr, 0, b);
        Transfer transfer=(Transfer)transfers.get(port);
        transfer.transferred=transfer.transferred+b;
        transfers.put(port, transfer);
        if(transfer.insert)
          System.out.println(transfers);
        b=bis.read(barr);
      }      
    }

    InputStream getIn(Bucket data, Socket sock) throws Exception
    { return data.getInputStream(); }
    OutputStream getOut(Bucket data, Socket sock) throws Exception
    { return sock.getOutputStream(); }
  }

  private class Suck extends Pump
  {
    public Suck(int i) { super(i); }

    InputStream getIn(Bucket data, Socket sock) throws Exception
    { return sock.getInputStream(); }
    OutputStream getOut(Bucket data, Socket sock) throws Exception
    { return data.getOutputStream(); }
  }
}
