package Freenet.contrib.xmlrpc;

import java.util.*;
import Freenet.client.*;
import Freenet.*;
import Freenet.support.*;
import java.io.*;

public class LocalUtil implements Util
{
  static final public String apiVersion = "0.1";
  Hashtable transfers=new Hashtable();
  Random random=new Random();
  int chunkSize=2048;
  Params params;

  public LocalUtil(Params p)
  {
    params=p;
    Core.init(params);
    chunkSize=Core.bufferSize;
  }

  public Hashtable getInfo()
  {
    Hashtable h=new Hashtable();
    h.put("API", apiVersion);
    h.put("Protocol", Core.protocolVersion);
    h.put("Node", Core.freenetVersion);
    h.put("Build", Core.buildNumber);
    h.put("Revision", Core.serverRevision);
    return h;
  }

  public String makeKeypair()
  {
    SimplifiedClient sc = new SimplifiedClient(params);
    Pair p = sc.makeKeypair();
    String pub=(String)p.first;
    String priv=(String)p.last;
    return pub+","+priv;
  }
}
