// Copyright 1999 Hannes Wallnfer, Raphael Spannocchi

package Freenet.contrib.xmlrpc;

import Freenet.*;
import Freenet.client.*;
import Freenet.contrib.xmlrpc.lib.*;
import Freenet.servlet.*;
import Freenet.servlet.util.*;
import Freenet.support.io.ReadInputStream;
import Freenet.support.Logger;
import java.io.*;
import java.util.Vector;
import java.util.*;

/**
 * A prototype servlet to run XML-RPC. <p>
 * 
 * Note that some clients like the one in Frontier 5 and the first version of XmlRpcApplet 
 * had XML-RPC requests hard-coded to URI /RPC2. To work with these clients, you have 
 * to configure your servlet environment to respond to /RPC2. This has been fixed in the 
 * new version of the XmlRpcApplet.
 * 
 */

public class XmlRpcServlet extends GenericServlet implements XmlRpcHandler
{

    public XmlRpcServer xmlrpc;
    static SimpleClient  sc=null;
    static ChunkedClient cc=null;
    static StreamingClient stc=null;
    static Util util=null;
    protected Logger l = null;

    public XmlRpcServlet(Params p)
    {
	try{
	    l = Core.logger;
	    log("Starting", Logger.DEBUG);
	    XmlRpc.debug=true;
	    XmlRpc.setKeepAlive(true);
	    String saxDriver = p.getParam("saxDriver");
	    if (saxDriver != null) {
		log("Setting SAX Driver to " + saxDriver, Logger.DEBUG);
		XmlRpc.setDriver(saxDriver);
	    }
	    xmlrpc = new XmlRpcServer ();
	    if(sc==null)
		sc=new LocalSimpleClient(p);
	    if(cc==null)
		cc=new LocalChunkedClient(p);
	    if(stc==null)
		stc=new LocalStreamingClient(p);
            if(util==null)
                util=new LocalUtil(p);
	    xmlrpc.addHandler("simple", sc);
	    xmlrpc.addHandler("chunked", cc);
	    xmlrpc.addHandler("streaming", stc);
            xmlrpc.addHandler("util", util);
	}catch(Exception e) {e.printStackTrace();}
    }

    public void service(ServletRequest req, ServletResponse res)
		throws ServletException, IOException  {
        ReadInputStream is=new ReadInputStream(((FreenetServletRequest)req).getNormalInputStream());
        String request=null;
        Hashtable headers=null;
        try
        {
          request=readRequest(is);
          headers=readHeaders(is);
        }
        catch(IOException e) {e.printStackTrace();}
        String slen=(String)headers.get("content-length");
        int len=Integer.parseInt(slen);
        ServerInputStream sis=new ServerInputStream(is, len);
	byte[] result = xmlrpc.execute(sis);
	OutputStream output = ((FreenetServletResponse)res).getNormalOutputStream();
        PrintWriter pw=new PrintWriter(output);
        pw.println("HTTP/1.0 200 OK");
        pw.println("Content-Type: text/xml");
	pw.println("Content-Length: "+result.length);
        pw.println();
        pw.flush();

	output.write (result);
	output.flush ();
        output.close();
    }

    private String readRequest(ReadInputStream is) throws IOException
    {
      return is.readTo('\n', '\r');
    }

    private Hashtable readHeaders(ReadInputStream is) throws IOException
    {
      String header;
      Hashtable headers=new Hashtable();
      boolean blank=false;
      while(!blank)
      {
        header=is.readTo('\n', '\r');
        if(header.equals(""))
        {
          blank=true;
        }
        else
        {
          int x=header.indexOf(':');
          String name=header.substring(0,x);
          String value=header.substring(x+2);
          headers.put(name.toLowerCase(), value);
        }
      }
      return headers;
    }

    /** 
     * Callback method for XML-RPC server
     */
    public Object execute (String methodname, Vector params) {
	return params;
    }

    protected void log(String msg, int priority) {
	if (l != null) {
	    l.log(this, msg, priority);
	}
    }
}
