#include <stdio.h>
#include <sys/socket.h>
#include <netdb.h>
#include <string.h>
#include <stddef.h>
#include <errno.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/types.h>
#include <arpa/inet.h>


#include <xmlrpc.h>
#include <xmlrpc_client.h>

#define NAME "XML-RPC C Freenet Client"
#define VERSION "0.1"

#define TRANSFERRING 0
#define DONE 1
#define FAILED 2
#define LISTENING 3
#define WAITING 4

void die_if_fault_occurred (xmlrpc_env *env)
{
  if (env->fault_occurred) {
    fprintf(stderr, "XML-RPC Fault: %s (%d)\n",
            env->fault_string, env->fault_code);
    exit(1);
  }
}

int main (int argc, char** argv)
{
  struct in_addr addr;
  int connected_socket, connected;
  struct sockaddr_in address;
  struct servent *serv;
  char *errpos;
  struct hostent *host;
  xmlrpc_env env;
  xmlrpc_value *result;
  xmlrpc_int32 port;
  unsigned char buffer[1024];
  int br;
  int status;

  if (argc < 3) {
    fprintf(stderr, "usage: streamingclient <url> <uri> <htl>\n");
    return -1;
  }

  /* Start up our XML-RPC client library. */
  xmlrpc_client_init(XMLRPC_CLIENT_NO_FLAGS, NAME, VERSION);

  /* Initialize our error-handling environment. */
  xmlrpc_env_init(&env);

  result = xmlrpc_client_call(&env, argv[1],
                              "streaming.getPort",
                              "()");
  die_if_fault_occurred(&env);

  xmlrpc_parse_value(&env, result, "i", &port);
  die_if_fault_occurred(&env);

  host = gethostbyname("localhost");
  if (host == NULL) {
    fprintf(stderr, "error resolving \"localhost\"\n");
    return -1;
  }
  addr.s_addr = ((struct in_addr *) *host->h_addr_list)->s_addr;

  memset((char *) &address, 0, sizeof(address));
  address.sin_family = AF_INET;
  address.sin_port = htons(port);
  address.sin_addr.s_addr = addr.s_addr;

  connected_socket = socket(AF_INET, SOCK_STREAM, 0);

  connected = connect(connected_socket, (struct sockaddr *) &address,
    sizeof(address));
  if (connected < 0) {
    fprintf(stderr, "connect failed\n");
    return -1;
  }

  xmlrpc_client_call(&env, argv[1],
                     "streaming.startRequest",
                     "(isi)", port, argv[2],
                     (xmlrpc_int32) atoi(argv[3]));
  die_if_fault_occurred(&env);

  do {
      br = read(connected_socket, buffer, 1024);
      if (br > 0) {
        fwrite(buffer, br, 1, stdout);
      }
  } while (br == 1024);

  result = xmlrpc_client_call(&env, argv[1],
                              "streaming.getStatus",
                              "(i)", port);
  die_if_fault_occurred(&env);

  xmlrpc_parse_value(&env, result, "i", &status);
  die_if_fault_occurred(&env);

  /* Dispose of our result value. */
  xmlrpc_DECREF(result);

  /* Clean up our error-handling environment. */
  xmlrpc_env_clean(&env);

  /* Shutdown our XML-RPC client library. */
  xmlrpc_client_cleanup();

  if (status != DONE) {
      fprintf(stderr, "died with status = %d\n", status);
      return 1;
  } else {
      return 0;
  }
}
