;;;; (net xmlrpc freenet) -- an XML-RPC interface to Freenet

(define-module (net xmlrpc freenet)
  :use-module (net xmlrpc)
  :use-module (oop goops))

(export
 *fred*
 simple.getFile
 simple.putFile
 chunked.getInfo
 chunked.startRequest
 chunked.nextChunk
 chunked.startInsert
 chunked.putChunk
 chunked.endInsert
 chunked.getStatus
 streaming.getInfo
 streaming.getPort
 streaming.startRequest
 streaming.getFileSize
 streaming.startInsert
 streaming.endInsert
 streaming.getStatus)

;;; This is the default server. If you put XML-PRC on a different
;;; port on Fred, try doing a (set! (port *fred*) whatever)

(define *fred* (make <xmlrpc-server>
		 #:hostname "localhost"
		 #:port 8888
		 #:url "/"))

;; SIMPLE INTERFACE

;;; Returns the contents of the file under key, using htl as the
;;; hops-to-live value.

(declare-xmlrpc-method *fred* simple.getFile key htl)

;;; Inserts data under key, using htl as the hops-to-live value.

(declare-xmlrpc-method *fred* simple.putFile key htl data)

;; Chunked

(declare-xmlrpc-method *fred* chunked.getInfo)
(declare-xmlrpc-method *fred* chunked.startRequest key htl)
(declare-xmlrpc-method *fred* chunked.nextChunk id)
(declare-xmlrpc-method *fred* chunked.startInsert)
(declare-xmlrpc-method *fred* chunked.putChunk id chunk)
(declare-xmlrpc-method *fred* chunked.endInsert id key htl)
(declare-xmlrpc-method *fred* chunked.getStatus id)

;; Streaming

(declare-xmlrpc-method *fred* streaming.getInfo)
(declare-xmlrpc-method *fred* streaming.getPort)
(declare-xmlrpc-method *fred* streaming.startRequest port key htl)
(declare-xmlrpc-method *fred* streaming.getFileSize port)
(declare-xmlrpc-method *fred* streaming.startInsert port)
(declare-xmlrpc-method *fred* streaming.endInsert port key htl)
(declare-xmlrpc-method *fred* streaming.getStatus id)
