#! /usr/bin/guile \
-e main -s
!#

;;;; chunked_get.scm -- gets a file using the chunked interface.

;; Copyright 2001, Evan Prodromou <evan@prodromou.san-francisco.ca.us>.

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2 of the License, or
;; (at your option) any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software
;; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

;; USAGE: chunked_get.scm [key] [htl]

(use-modules (net xmlrpc freenet))

(define (main args)
  (catch 'xmlrpc-fault
	 (lambda ()
	   (let* ((key (list-ref args 1))
		  (htl (string->number (list-ref args 2)))
		  (id (chunked.startRequest key htl)))
	     (let do-next-chunk ((i id))
	       (let ((stat (chunked.getStatus i)))
		 (if (> 0 stat)
		     (format #t "Status = ~A" stat)
		     (begin
		       (display (chunked.nextChunk i))
		       (do-next-chunk i)))))))
	 (lambda args
	   (format #t "Got args: ~A" args))))

