#! /usr/bin/guile \
-e main -s
!#

;;;; chunked_get.scm -- gets a file using the chunked interface.

;; Copyright 2001, Evan Prodromou <evan@prodromou.san-francisco.ca.us>.

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2 of the License, or
;; (at your option) any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software
;; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

;; USAGE: chunked_put.scm [key] [htl] [fname]

(use-modules (net xmlrpc freenet)
	     (net xmlrpc)
	     (oop goops))

(define *chunk-size* 4096)

(define (filesize fname)
  (let* ((fport (open-input-file fname))
	 (end (seek fport 0 SEEK_END)))
    (close-input-port fport)
    end))

(define (read-chunk port size)
  (let* ((buffer (make-string size #\nul))
	 (cb (uniform-array-read! buffer port)))
    (if (<= cb 0)
	""
	(if (< cb size)
	    (substring buffer 0 cb)
	    buffer))))

(define (main args)
  (catch 'xmlrpc-fault
	 (lambda ()
	   (let* ((key (list-ref args 1))
		  (htl (string->number (list-ref args 2)))
		  (fname (list-ref args 3))
		  (size (filesize fname))
		  (infile (open-input-file fname))
		  (id (chunked.startInsert)))
	     (format #t "Inserting ~A: ~A bytes\n" fname size)
	     (let do-next-chunk ((i id) (cnt 0))
	       (let ((stat (chunked.getStatus i)))
		 (if (> 0 stat)
		     #f
		     (let* ((chunk (read-chunk infile *chunk-size*))
			    (len (string-length chunk)))
		       (if (= 0 len)
			   #t
			   (let ((dv (make <base64-value> #:value chunk))
				 (total (+ cnt len)))
			     (format #t "Inserting next chunk (~A of ~A)\n" total size)
			     (chunked.putChunk i dv)
			     (do-next-chunk i total)))))))
	     (format #t "Done with data upload; sending insert for ~A (~A htl)\n" key htl)
	     (newline)
	     (chunked.endInsert id key htl)))
	 (lambda args
	   (format #t "Got args: ~A" args))))

