#! /usr/bin/guile \
-e main -s
!#

;;;; put.scm -- gets a file using the chunked interface.

;; Copyright 2001, Evan Prodromou <evan@prodromou.san-francisco.ca.us>.

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2 of the License, or
;; (at your option) any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software
;; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

;; USAGE: put.scm [key] [htl] [fname]

(use-modules (net xmlrpc freenet)
	     (net xmlrpc)
	     (oop goops))

(define (filesize fname)
  (let* ((fport (open-input-file fname))
	 (end (seek fport 0 SEEK_END)))
    (close-input-port fport)
    end))

(define (read-chunk port size)
  (let* ((buffer (make-string size #\nul))
	 (cb (uniform-array-read! buffer port)))
    (if (<= cb 0)
	""
	(if (< cb size)
	    (substring buffer 0 cb)
	    buffer))))

(define (main args)
  (catch 'xmlrpc-fault
	 (lambda ()
	   (let* ((key (list-ref args 1))
		  (htl (string->number (list-ref args 2)))
		  (fname (list-ref args 3))
		  (size (filesize fname))
		  (fport (open-input-file fname))
		  (chunk (read-chunk fport size))
		  (dv (make <base64-value> #:value chunk)))
	       (close-input-port fport)
	       (simple.putFile key htl dv)))
	 (lambda args
	   (format #t "Got args: ~A" args))))

