package Freenet.contrib.xmlrpc.java;

import Freenet.contrib.xmlrpc.lib.*;
import Freenet.contrib.xmlrpc.*;
import java.util.*;
import Freenet.*;

abstract public class ChunkedClientCLI
{
  public void run(String[] args)
  {
    if(!checkArgs(args))
    {
      printHelp();
      return;
    }

    Integer i;
    try { new Integer(args[1]); }
    catch(NumberFormatException e)
    {
      System.err.println("Invalid port number");
      return;
    }

    ChunkedClient client;
    try { client=checkMode(args[0], args[1]); }
    catch(IllegalArgumentException e) {return;}
    catch(Exception e)
    {
      System.err.println("Error creating XML-RPC connection.");
      System.err.println(e);
      return;
    }

    execute(client, args);
  }

  public boolean checkArgs(String[] args)
  {
    return args.length==2;
  }

  public ChunkedClient checkMode(String modeStr, String port) throws IllegalArgumentException, Exception
  {
    if(modeStr.equals("local")) return new LocalChunkedClient(new Params(Params.defaultRCFiles));
    else if(modeStr.equals("XML-RPC")) return new RemoteChunkedClient(port);
    else
    {
      System.err.println("Unsupported mode. Only local and XML-RPC supported");
      throw new IllegalArgumentException();
    }
  }

  public void printHelp()
  {
      printUsage();
      printModeHelp();
      printPortHelp();
  }

  public void printUsage()
  {
      System.err.println(getName()+" [mode] [port]");
  }

  public void printModeHelp()
  {
      System.err.println("Mode is either local or XML-RPC.");
      System.err.println("local makes direct calls to the Java library.");
      System.err.println("XML-RPC mode is a light, standard, multi-language protocol.");
      System.err.println("Use this if you have the Freenet XML-RPC plugin.");
  }

  public void printPortHelp()
  {
      System.err.println("Port is the either the port Freenet is running on or the port that the");
      System.err.println("XML-RPC plugin is running on.");
  }

  public abstract String getName();
  public abstract void execute(ChunkedClient client, String[] args);
}
