package Freenet.contrib.xmlrpc.java;

import Freenet.contrib.xmlrpc.lib.*;
import Freenet.contrib.xmlrpc.ChunkedClient;
import java.util.*;
import java.io.*;

public class ChunkedInsert extends ChunkedClientCLI
{
  static public void main(String[] args) { new ChunkedInsert().run(args); }

  public String getName() {return "insert";}

  public boolean checkArgs(String[] args) { return args.length==4; }

  public void printUsage()
  {
    System.err.println("insert [mode] [port] [key] [filename]");
  }

  public void execute(ChunkedClient client, String[] args)
  {
System.out.println("execute");
    String key=args[2];
    String filename=args[3];
System.out.println("args");
    File file;
    FileInputStream fis;
    try
    {
      file=new File(filename);
      fis=new FileInputStream(file);
    }
    catch(Exception e)
    {
      System.err.println("Error opening file.");
      System.err.println(e);
      return;
    }
System.out.println("files");
    int id=0;
    try
    {
System.out.println("try");
      id=client.startInsert(key, 1);
System.out.println("started");
      byte[] chunk=new byte[2048];
      while(true)
      {
        int num=fis.read(chunk);
        if(num==-1)
        {
System.out.println("finished");
          client.endInsert(id);
          break;
        }
        byte[] towrite=chunk;
        if(num<chunk.length)
        {
          towrite=new byte[num];
          for(int x=0;x<towrite.length;x++)
            towrite[x]=chunk[x];
        }
        client.putChunk(id, towrite);
System.out.println("put");
      }
    }
    catch(Exception e)
    {
      int status=ChunkedClient.FAILED;
      try { status=client.getStatus(id); }
      catch(Exception f) {System.err.println(e);}
      if(status==ChunkedClient.DONE)
      {
        System.err.println("DONE");
        try { fis.close(); } catch(IOException f) {f.printStackTrace();}
      }
      else
        System.err.println("error: "+e);
    }
  }
}
