package Freenet.contrib.xmlrpc.java;

import Freenet.contrib.xmlrpc.lib.*;
import Freenet.contrib.xmlrpc.ChunkedClient;
import java.util.*;
import java.io.*;

public class ChunkedRequest extends ChunkedClientCLI
{
  static public void main(String[] args) { new ChunkedRequest().run(args); }

  public String getName() {return "request";}

  public boolean checkArgs(String[] args) { return args.length==4; }

  public void printUsage()
  {
    System.err.println("request [mode] [port] [key] [filename]");
  }

  public void execute(ChunkedClient client, String[] args)
  {
    String key=args[2];
    String filename=args[3];
    File file;
    FileOutputStream fos;
    try
    {
      file=new File(filename);
      fos=new FileOutputStream(file);
    }
    catch(Exception e)
    {
      System.err.println("Error opening file.");
      System.err.println(e);
      return;
    }
    int id=0;
    try
    {
      id=client.startRequest(key, 1);
      while(true)
      {
        byte[] chunk=client.nextChunk(id);
        fos.write(chunk);
        fos.flush();
      }
    }
    catch(Exception e)
    {
      int status=ChunkedClient.FAILED;
      try { status=client.getStatus(id); }
      catch(Exception f) {System.err.println(e);}
      if(status==ChunkedClient.DONE)
      {
        try { fos.close(); } catch(IOException f) {f.printStackTrace();}
      }
      else
      {
        System.err.println("error: "+e);
        file.delete();
      }
    }
  }
}
