package Freenet.contrib.xmlrpc.java;

import Freenet.contrib.xmlrpc.lib.*;
import Freenet.contrib.xmlrpc.ChunkedClient;
import java.util.*;

public class RemoteChunkedClient implements ChunkedClient
{
  XmlRpcClient client;

  public RemoteChunkedClient(String port) throws Exception
  {
    client=new XmlRpcClientLite("http://localhost:"+port+"/");
  }

  public Hashtable getInfo() throws Exception
  {
    Vector v=new Vector();
    return (Hashtable)client.execute("chunked.getInfo", v);    
  }

  public int startRequest(String key, int htl) throws Exception
  {
    Vector v=new Vector();
    v.addElement(key);
    v.addElement(new Integer(htl));
    return ((Integer)client.execute("chunked.startRequest", v)).intValue();
  }

  public int startInsert(String key, int htl) throws Exception
  {
    Vector v=new Vector();
    v.addElement(key);
    v.addElement(new Integer(htl));
    return ((Integer)client.execute("chunked.startInsert", v)).intValue();
  }

  public void endInsert(int id) throws Exception
  {
    Vector v=new Vector();
    v.addElement(new Integer(id));
    client.execute("chunked.endInsert", v);
  }

  public int getNumberOfChunks(int id) throws Exception
  {
    Vector v=new Vector();
    v.addElement(new Integer(id));
    return ((Integer)client.execute("chunked.getNumberOfChunks", v)).intValue();
  }

  public byte[] nextChunk(int id) throws Exception
  {
    Vector v=new Vector();
    v.addElement(new Integer(id));
    return (byte[])client.execute("chunked.nextChunk", v);
  }

  public void putChunk(int id, byte[] chunk) throws Exception
  {
    Vector v=new Vector();
    v.addElement(new Integer(id));
    v.addElement(chunk);
    client.execute("chunked.putChunk", v);
  }

  public int getStatus(int id) throws Exception
  {
    Vector v=new Vector();
    v.addElement(new Integer(id));
    return ((Integer)client.execute("chunked.getStatus", v)).intValue();
  }
}
