package Freenet.contrib.xmlrpc.java;

import Freenet.contrib.xmlrpc.lib.*;
import Freenet.contrib.xmlrpc.SimpleClient;
import java.util.*;

public class RemoteSimpleClient implements SimpleClient
{
  XmlRpcClient client;

  public RemoteSimpleClient(String port) throws Exception
  {
    client=new XmlRpcClientLite("http://localhost:"+port+"/");
  }

  public byte[] getFile(String key, int htl) throws Exception
  {
    Vector v=new Vector();
    v.addElement(key);
    v.addElement(new Integer(htl));
    return (byte[])client.execute("simple.getFile", v);
  }

  public void putFile(String key, int htl, byte[] file) throws Exception
  {
    Vector v=new Vector();
    v.addElement(key);
    v.addElement(new Integer(htl));
    v.addElement(file);
    client.execute("simple.putFile", v);
  }
}
