package Freenet.contrib.xmlrpc.java;

import Freenet.contrib.xmlrpc.lib.*;
import Freenet.contrib.xmlrpc.StreamingClient;
import java.util.*;

public class RemoteStreamingClient implements StreamingClient
{
  XmlRpcClient client;

  public RemoteStreamingClient(String port) throws Exception
  {
    client=new XmlRpcClientLite("http://localhost:"+port+"/");
  }

  public int getPort() throws Exception
  {
    Vector v=new Vector();
    return ((Integer)client.execute("streaming.getPort", v)).intValue();
  }

  public int startRequest(int port, String key, int htl) throws Exception
  {
    Vector v=new Vector();
    v.addElement(new Integer(port));
    v.addElement(key);
    v.addElement(new Integer(htl));
    return ((Integer)client.execute("streaming.startRequest", v)).intValue();
  }

  public int getFileSize(int port) throws Exception
  {
    Vector v=new Vector();
    v.addElement(new Integer(port));
    return ((Integer)client.execute("streaming.getFileSize", v)).intValue();
  }

  public int setFileSize(int port, int size) throws Exception
  {
    Vector v=new Vector();
    v.addElement(new Integer(port));
    v.addElement(new Integer(size));
    return ((Integer)client.execute("streaming.setFileSize", v)).intValue();
  }

  public String getKey(int port) throws Exception
  {
    Vector v=new Vector();
    v.addElement(new Integer(port));
    return (String)client.execute("streaming.getKey", v);
  }

  public int startInsert(int port, String key, int htl) throws Exception
  {
    Vector v=new Vector();
    v.addElement(new Integer(port));
    v.addElement(key);
    v.addElement(new Integer(htl));
    return ((Integer)client.execute("streaming.startInsert", v)).intValue();
  }

  public int endInsert(int port) throws Exception
  {
    Vector v=new Vector();
    v.addElement(new Integer(port));
    return ((Integer)client.execute("streaming.endInsert", v)).intValue();
  }

  public int getStatus(int id) throws Exception
  {
    Vector v=new Vector();
    v.addElement(new Integer(id));
    return ((Integer)client.execute("streaming.getStatus", v)).intValue();
  }
}
