package Freenet.contrib.xmlrpc.java;

import Freenet.contrib.xmlrpc.lib.*;
import Freenet.contrib.xmlrpc.SimpleClient;
import java.util.*;
import java.io.*;

public class SimpleInsert extends SimpleClientCLI
{
  static public void main(String[] args) { new SimpleInsert().run(args); }

  public String getName() {return "insert";}

  public boolean checkArgs(String[] args) { return args.length==4; }

  public void printUsage()
  {
    System.err.println("insert [mode] [port] [key] [filename]");
  }

  public void execute(SimpleClient client, String[] args)
  {
    String key=args[2];
    String filename=args[3];
    File file;
    FileInputStream fis;
    try
    {
      file=new File(filename);
      fis=new FileInputStream(file);
    }
    catch(Exception e)
    {
      System.err.println("Error opening file.");
      System.err.println(e);
      return;
    }

    try
    {
      byte[] data=new byte[(int)file.length()];
      int num = fis.read(data);
      if(num!=data.length) throw new EOFException();
      client.putFile(key, 1, data);
    }
    catch(Exception e)
    {
      System.err.println("error: "+e);
      e.printStackTrace();
    }
  }
}
