package Freenet.contrib.xmlrpc.java;

import Freenet.contrib.xmlrpc.lib.*;
import Freenet.contrib.xmlrpc.SimpleClient;
import java.util.*;
import java.io.*;

public class SimpleRequest extends SimpleClientCLI
{
  static public void main(String[] args) { new SimpleRequest().run(args); }

  public String getName() {return "request";}

  public boolean checkArgs(String[] args) { return args.length==4; }

  public void printUsage()
  {
    System.err.println("request [mode] [port] [key] [filename]");
  }

  public void execute(SimpleClient client, String[] args)
  {
    String key=args[2];
    String filename=args[3];
    File file;
    FileOutputStream fos;
    try
    {
      file=new File(filename);
      fos=new FileOutputStream(file);
    }
    catch(Exception e)
    {
      System.err.println("Error opening file.");
      System.err.println(e);
      return;
    }

    try
    {
      byte[] data=client.getFile(key, 1);
      fos.write(data);
      fos.flush();
    }
    catch(Exception e)
    {
      System.err.println("error: "+e);
      e.printStackTrace();
      file.delete();
    }
  }
}
