package Freenet.contrib.xmlrpc.java;

import Freenet.contrib.xmlrpc.lib.*;
import Freenet.contrib.xmlrpc.StreamingClient;
import java.util.*;
import java.io.*;
import java.net.*;
import Freenet.*;

public class StreamingInsert extends StreamingClientCLI
{
  static public void main(String[] args)
  { 
    new StreamingInsert().run(args);
  }

  public String getName() {return "insert";}

  public boolean checkArgs(String[] args) { return args.length==4; }

  public void printUsage()
  {
    System.err.println("insert [mode] [port] [key] [filename]");
  }

  public void execute(StreamingClient client, String[] args)
  {
    String key=args[2];
    String filename=args[3];
    File file;
    FileInputStream fis;
    try
    {
      file=new File(filename);
      fis=new FileInputStream(file);
    }
    catch(Exception e)
    {
      System.err.println("Error opening file.");
      System.err.println(e);
      return;
    }
    int id=0;
    try
    {
      id=client.getPort();
      Socket sock=new Socket("localhost", id);
      client.setFileSize(id, (int)file.length()); // XML-RPC doesn't support long ints.
      client.startInsert(id, key, 1);
      BufferedOutputStream bos=new BufferedOutputStream(sock.getOutputStream());
      byte[] barr=new byte[Core.bufferSize];
      int b=fis.read(barr);
      while(b!=-1)
      {
        bos.write(barr, 0, b);
        bos.flush();
        b=fis.read(barr);
      }
      bos.close();
      sock.close();
//      client.endInsert(id);
    }
    catch(Exception e)
    {
      int status=StreamingClient.FAILED;
      try { status=client.getStatus(id); }
      catch(Exception f) {System.err.println(e);}
      if(status==StreamingClient.DONE)
      {
        System.err.println("DONE");
        try { fis.close(); } catch(IOException f) {f.printStackTrace();}
      }
      else
      {
        System.err.println("error: "+e);
        file.delete();
      }
    }
  }
}

