package Freenet.contrib.xmlrpc.java;

import Freenet.contrib.xmlrpc.lib.*;
import Freenet.contrib.xmlrpc.StreamingClient;
import java.util.*;
import java.io.*;
import java.net.*;
import Freenet.*;

public class StreamingRequest extends StreamingClientCLI
{
  static public void main(String[] args)
  { 
    new StreamingRequest().run(args);
  }

  public String getName() {return "request";}

  public boolean checkArgs(String[] args) { return args.length==4; }

  public void printUsage()
  {
    System.err.println("request [mode] [port] [key] [filename]");
  }

  public void execute(StreamingClient client, String[] args)
  {
    String key=args[2];
    String filename=args[3];
    File file;
    FileOutputStream fos;
    try
    {
      file=new File(filename);
      fos=new FileOutputStream(file);
    }
    catch(Exception e)
    {
      System.err.println("Error opening file.");
      System.err.println(e);
      return;
    }
    int id=0;
    try
    {
      id=client.getPort();
      Socket sock=new Socket("localhost", id);
      client.startRequest(id, key, 1);

      int size=client.getFileSize(id);

      BufferedInputStream bis=new BufferedInputStream(sock.getInputStream());
      byte[] barr=new byte[Core.bufferSize];

      int bytesRead=0;
      int position=0;
      int newpos=0;

      int b=bis.read(barr);
      while(b!=-1)
      {
        fos.write(barr, 0, b);

        bytesRead=bytesRead+b;
        if(size!=-1)
          newpos=(bytesRead*80)/size;
        if(newpos>position)
        {
          position=newpos;
          System.out.print("#");
        }

        b=bis.read(barr);
      }      
      System.out.println();
    }
    catch(Exception e)
    {
      int status=StreamingClient.FAILED;
      try { status=client.getStatus(id); }
      catch(Exception f) {System.err.println(e);}
      if(status==StreamingClient.DONE)
      {
        try { fos.close(); } catch(IOException f) {f.printStackTrace();}
      }
      else
      {
        System.err.println("error: "+e);
        file.delete();
      }
    }
  }
}

