// SAX parser factory.
// No warranty; no copyright -- use this as you will.

package Freenet.contrib.xmlrpc.xml.sax.helpers;

import java.lang.ClassNotFoundException;
import java.lang.IllegalAccessException;
import java.lang.InstantiationException;
import java.lang.SecurityException;
import java.lang.ClassCastException;

import Freenet.contrib.xmlrpc.xml.sax.Parser;


/**
 * Java-specific class for dynamically loading SAX parsers.
 *
 * <blockquote>
 * <em>This module, both source code and documentation, is in the
 * Public Domain, and comes with <strong>NO WARRANTY</strong>.</em>
 * </blockquote>
 *
 * <p><strong>Note:</strong> This class is designed to work with the now-deprecated
 * SAX1 {@link Freenet.contrib.xmlrpc.xml.sax.Parser Parser} class.  SAX2 applications should use
 * {@link Freenet.contrib.xmlrpc.xml.sax.helpers.XMLReaderFactory XMLReaderFactory} instead.</p>
 *
 * <p>ParserFactory is not part of the platform-independent definition
 * of SAX; it is an additional convenience class designed
 * specifically for Java XML application writers.  SAX applications
 * can use the static methods in this class to allocate a SAX parser
 * dynamically at run-time based either on the value of the
 * `Freenet.contrib.xmlrpc.xml.sax.parser' system property or on a string containing the class
 * name.</p>
 *
 * <p>Note that the application still requires an XML parser that
 * implements SAX1.</p>
 *
 * @deprecated This class works with the deprecated
 *             {@link Freenet.contrib.xmlrpc.xml.sax.Parser Parser}
 *             interface.
 * @since SAX 1.0
 * @author David Megginson, 
 *         <a href="mailto:sax@megginson.com">sax@megginson.com</a>
 * @version 2.0
 * @see Freenet.contrib.xmlrpc.xml.sax.Parser
 * @see java.lang.Class
 */
public class ParserFactory {
    
    
    /**
     * Private null constructor.
     */
    private ParserFactory ()
    {
    }
    
    
    /**
     * Create a new SAX parser using the `Freenet.contrib.xmlrpc.xml.sax.parser' system property.
     *
     * <p>The named class must exist and must implement the
     * {@link Freenet.contrib.xmlrpc.xml.sax.Parser Parser} interface.</p>
     *
     * @exception java.lang.NullPointerException There is no value
     *            for the `Freenet.contrib.xmlrpc.xml.sax.parser' system property.
     * @exception java.lang.ClassNotFoundException The SAX parser
     *            class was not found (check your CLASSPATH).
     * @exception IllegalAccessException The SAX parser class was
     *            found, but you do not have permission to load
     *            it.
     * @exception InstantiationException The SAX parser class was
     *            found but could not be instantiated.
     * @exception java.lang.ClassCastException The SAX parser class
     *            was found and instantiated, but does not implement
     *            Freenet.contrib.xmlrpc.xml.sax.Parser.
     * @see #makeParser(java.lang.String)
     * @see Freenet.contrib.xmlrpc.xml.sax.Parser
     */
    public static Parser makeParser ()
	throws ClassNotFoundException,
	IllegalAccessException, 
	InstantiationException,
	NullPointerException,
	ClassCastException
    {
	String className = System.getProperty("Freenet.contrib.xmlrpc.xml.sax.parser");
        if(className==null) className="Freenet.contrib.xmlrpc.xml.SAXDriver";
	if (className == null) {
	    throw new NullPointerException("No value for sax.parser property");
	} else {
	    return makeParser(className);
	}
    }
    
    
    /**
     * Create a new SAX parser object using the class name provided.
     *
     * <p>The named class must exist and must implement the
     * {@link Freenet.contrib.xmlrpc.xml.sax.Parser Parser} interface.</p>
     *
     * @param className A string containing the name of the
     *                  SAX parser class.
     * @exception java.lang.ClassNotFoundException The SAX parser
     *            class was not found (check your CLASSPATH).
     * @exception IllegalAccessException The SAX parser class was
     *            found, but you do not have permission to load
     *            it.
     * @exception InstantiationException The SAX parser class was
     *            found but could not be instantiated.
     * @exception java.lang.ClassCastException The SAX parser class
     *            was found and instantiated, but does not implement
     *            Freenet.contrib.xmlrpc.xml.sax.Parser.
     * @see #makeParser()
     * @see Freenet.contrib.xmlrpc.xml.sax.Parser
     */
    public static Parser makeParser (String className)
	throws ClassNotFoundException,
	IllegalAccessException, 
	InstantiationException,
	ClassCastException
    {
	return (Parser)(Class.forName(className).newInstance());
    }
    
}

// end of ParserFactory.java
