package Freenet.crypt;
/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.
*/

import java.io.*;
import java.net.*;
import Freenet.crypt.ciphers.*;

/**
 * This class, given two streams, will perform key-negotiation using any
 * KEProtocol, set up encrypted streams (in the form of 
 * CipherInput/OutputStreams), and make the new streams available.  In
 * many ways it behaves like java.net.Socket, as a form of constructor.
 */
public class CipherLink {
    private CipherInputStream s_in;
    private CipherOutputStream s_out;

    public CipherLink(RandomSource rs, KEProtocol p, BlockCipher c,
		      InputStream in, OutputStream out) throws IOException {
	byte[] key=new byte[c.getKeySize() >> 3];
	p.negotiateKey(in, out, key, 0, key.length);
	c.initialize(key);
	s_out=new CipherOutputStream(rs, c, out);
	s_in=new CipherInputStream(c, in);
	Util.wipe(key);
    }

    public InputStream getInputStream() {
	return s_in;
    }

    public OutputStream getOutputStream() {
	return s_out;
    }

    public static void main(String[] args) throws Exception {
	Yarrow rs=new Yarrow();

	InputStream in=null;
	OutputStream out=null;
	Socket sock=null;
	if (args.length==0) {
	    ServerSocket ssock=new ServerSocket(20204);
	    sock=ssock.accept();
	} else {
	    sock=new Socket(args[0], 20204);
	}
	in=sock.getInputStream();
	out=sock.getOutputStream();

	final InputStream cin;
	final OutputStream cout;


	BlockCipher cctx=new Rijndael();//new Twofish();
	CipherLink cl=new CipherLink(rs,
				     new DiffieHellman(Global.DHgroupA, 
						       rs), cctx,
				     in, out);

	cin=cl.getInputStream();
	cout=cl.getOutputStream();

	/*	cin=System.in;
	cout=System.out;
	*/
	
	byte[] buffer=new byte[65536];
	int tbc=0;
	long start=System.currentTimeMillis();
	for (int bc=1; bc>0;) {
	    if (args.length==0) {
		bc=System.in.read(buffer);
		if (bc>0) {
		    tbc+=bc;
		    cout.write(buffer, 0, bc);
		    cout.flush();
		}
	    } else {
		bc=cin.read(buffer);
		if (bc>0) {
		    tbc+=bc;
		    System.out.write(buffer, 0, bc);
		}
	    }
	}
	cout.flush();
	System.out.flush();
	long elapsed=System.currentTimeMillis()-start;
	System.err.println(tbc+" bytes ("+(tbc/elapsed)+" bytes/ms)");
    }
}

