package Freenet.crypt;

import java.math.BigInteger;
import java.io.*;

/**
 * Holds a Diffie-Hellman key-exchange group
 */
public class DHGroup extends KeyPair {

    public DHGroup(BigInteger p, BigInteger g) {
	super(null, new BigInteger[] {p,g});
    }

    public void write(OutputStream out) throws IOException {
	super.write(new DataOutputStream(out), getClass().getName());
    }

    public static CryptoKey read(DataInputStream i) throws IOException {
	BigInteger[][] keys=KeyPair.readKeys(i);
	return new DHGroup(keys[1][0], keys[1][1]);
    }

    public BigInteger getP() {
	return y[0];
    }

    public BigInteger getG() {
	return y[1];
    }

    public String keyType() {
	return "DHG-"+y[0].bitLength();
    }
}




