package Freenet.crypt;

import java.math.BigInteger;
import java.util.Random;
import java.util.StringTokenizer;
import Freenet.support.Fields;
import java.io.*;

/**
 * Holds DSA group parameters.  These are the public (possibly shared) values
 * needed for the DSA algorithm
 */
public class DSAGroup extends KeyPair {

    public DSAGroup(BigInteger p, BigInteger q, BigInteger g) {
	super(null, new BigInteger[] {p, q, g});
    }

    /**
     * Parses a DSA Group from a string, where p, q, and g are 
     * in unsigned hex-strings, separated by a commas
     */
    public static DSAGroup parse(String grp) {
	StringTokenizer str=new StringTokenizer(grp, ",");
	BigInteger p,q,g;
	p=Util.byteArrayToMPI(Util.hexToBytes(str.nextToken()));
	q=Util.byteArrayToMPI(Util.hexToBytes(str.nextToken()));
	g=Util.byteArrayToMPI(Util.hexToBytes(str.nextToken()));
	return new DSAGroup(p,q,g);
    }

    public static KeyPair read(DataInputStream i) throws IOException {
	BigInteger[][] keys=KeyPair.readKeys(i);
	return new DSAGroup(keys[1][0], keys[1][1], keys[1][2]);
    }

    public void write(OutputStream out) throws IOException {
	super.write(new DataOutputStream(out), getClass().getName());
    }

    public String keyType() {
	return "DSAg-"+y[0].bitLength();
    }

    public BigInteger getP() {
	return y[0];
    }

    public BigInteger getQ() {
	return y[1];
    }

    public BigInteger getG() {
	return y[2];
    }

    public static DSAGroup generate(int bits, Random r) {
	SHA1 ctx=new SHA1();
	BigInteger twoToLmin1=Util.TWO.pow(1023);

	int n=(bits-1)/160;
	int b=(bits-1)-(160*n)
;
	int p1c=0, p2c=0;
	BigInteger S, q, twoToG;
	do {
	    if (p1c++%10==0)
		System.err.print(".");
	    S=new BigInteger(bits>>2, r);
	    int g=S.bitLength();
	    twoToG=Util.TWO.pow(g);

	    BigInteger U=
		new BigInteger(xor(hash(ctx, Util.MPIbytes(S)),
				   hash(ctx, Util.MPIbytes(S.add(Util.ONE).mod(twoToG)))));
	    
	    q=U.setBit(U.bitLength()).setBit(0);
	} while (q.bitLength()!=160 || !q.isProbablePrime(80));
	
	BigInteger C=Util.ZERO;
	BigInteger N=Util.TWO;
	
	BigInteger[] V=new BigInteger[n];
	step7: 
	do {
	    for (int k=0; k<n; k++) {
		V[k]=new BigInteger(hash(ctx, Util.MPIbytes(S.add(N)
							    .add(BigInteger.valueOf(k))
							    .mod(twoToG))));
	    }
	    
	    BigInteger W=V[0];
	    for (int i=1; i<n-1; i++) {
		W=W.add(Util.TWO.pow(160*i).multiply(V[i]));
	    }
	    W=W.add(Util.TWO.pow(160*n)
		    .multiply(V[n-1].mod(Util.TWO.pow(b))));
	    BigInteger X=W.add(twoToLmin1);
	    
	    BigInteger pTmp=X.mod(Util.TWO.multiply(q)).subtract(Util.ONE);
	    BigInteger p=X.subtract(pTmp);

	    if (p.compareTo(twoToLmin1) != -1) {
		if (p2c++%20==0)
		    System.err.print("+");
		if (p.isProbablePrime(80)) {
		    System.err.println("S=0x"+S.toString(16));
		    System.err.println("C="+C);
		    System.err.println("N="+N);
		    //		    System.err.println("new BigInteger(\""+
		    //	       p.toString(16)+"\",16),");
		    //System.err.println("new BigInteger(\""+
		    //	       q.toString(16)+"\",16),");
		    
		    BigInteger pmin1=p.subtract(Util.ONE),
			h, g;
		    
		    do {
			h=new BigInteger(512, r);
			g=h.modPow(pmin1.divide(q), p);
		    } while ((h.compareTo(p.subtract(Util.ONE)) != -1) &&
			     (g.compareTo(Util.ONE) < 1));
		    //		    System.err.println("new BigInteger(\""+
		    //	       g.toString(16)+"\",16),");
		    return new DSAGroup(p, q, g);
		} else {
		    C=C.add(Util.ONE);
		    N=N.add(N).add(BigInteger.valueOf(n)).add(Util.ONE);
		    if (C.compareTo(BigInteger.valueOf(4096)) == 0)
			return generate(bits, r);
		    else
			continue step7;
		}
	    }
	} while (true);
    }
    
    public static byte[] xor(byte[] b1, byte[] b2) {
	byte[] res=new byte[b1.length+1];
	for (int i=0; i<b1.length; i++) {
	    res[i+1]=(byte)(b1[i]^b2[i]);
	}
	return res;
    }

    public static byte[] hash(SHA1 ctx, byte[] val) {
	ctx.update(val, 0, val.length);
	byte[] res=ctx.digest();
	return res;
    }

    public static void main(String[] args) {
	generate(Integer.parseInt(args[0]), 
		 new Yarrow("/dev/random","SHA1","Rijndael"));
    }
}

    
