package Freenet.crypt;

import java.math.BigInteger;
import java.io.*;
import java.util.Random;

/**
 * Holds a DSA key pair.  The private key (x) is used for signing,
 * while the public key (y) is used for verification.
 */
public class DSAKeyPair extends KeyPair {


    public DSAKeyPair(DSAGroup grp, BigInteger pub) {
	super(null, new BigInteger[] {pub}, grp);
    }

    /**
     * Use the 160 bit integer <b>priv</b> as the private key, and
     * generate the public key according to the standard
     */
    public DSAKeyPair(BigInteger priv, DSAGroup grp) {
	super(new BigInteger[] {priv}, 
	      new BigInteger[] {grp.getG().modPow(priv, grp.getP())},
	      grp);
    }

    public static KeyPair read(DataInputStream i, 
			       CryptoKey dependent) throws IOException {
	BigInteger[][] keys=KeyPair.readKeys(i);
	
	return new DSAKeyPair(keys[0][0], (DSAGroup)dependent);
    }
 
    public void write(OutputStream out) throws IOException {
	super.write(new DataOutputStream(out), getClass().getName());
    }

    public String keyType() {
	return "DSA-1024";
    }

    public DSAGroup getGroup() {
	return (DSAGroup)dependent;
    }

    public BigInteger getP() {
	return getGroup().getP();
    }

    public BigInteger getQ() {
	return getGroup().getQ();
    }

    public BigInteger getG() {
	return getGroup().getG();
    }

    public BigInteger getX() {
	return x[0];
    }

    public BigInteger getY() {
	return y[0];
    }

    public static void main(String[] args) throws Exception {
	DSAKeyPair kp=null;
	if (args[0].equals("read")) {
	    File f=new File(args[1]);
	    kp=(DSAKeyPair)CryptoKey.read(new FileInputStream(f));
	} else {
	    File f=new File(args[0]);
	    FileOutputStream out=new FileOutputStream(f);
	    kp=new DSAKeyPair(new BigInteger(160,new Yarrow()),
			      Global.DSAgroupA);
	    kp.write(out);
	    out.close();
	}
	System.err.println(kp.verboseToString());
    }
}















































