package Freenet.crypt;

import java.math.BigInteger;
import java.io.*;
import java.util.Random;

public class DSASignature {
    private final BigInteger r, s;

    public DSASignature(InputStream in) throws IOException {
	r=Util.readMPI(in);
	s=Util.readMPI(in);
    }

    /**
     * Parses a DSA Signature pair from a string, where r and s are 
     * in unsigned hex-strings, separated by a comma
     */
    public DSASignature(String sig) {
	int x=sig.indexOf(',');
	r=Util.byteArrayToMPI(Util.hexToBytes(sig.substring(0,x)));
	s=Util.byteArrayToMPI(Util.hexToBytes(sig.substring(x+1)));
    }

    public void write(OutputStream o) throws IOException {
	Util.writeMPI(r, o);
	Util.writeMPI(s, o);
    }

    public DSASignature(BigInteger r, BigInteger s) {
	this.r=r;
	this.s=s;
    }

    public BigInteger getR() {
	return r;
    }

    public BigInteger getS() {
	return s;
    }

    public String toString() {
	StringBuffer sb=new StringBuffer();
	sb.append(r.toString(16).toUpperCase()).append(',');
	sb.append(s.toString(16).toUpperCase());
	return sb.toString();
    }
		  
}
