package Freenet.crypt;
/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.
*/
import java.io.*;
import java.math.BigInteger;
import java.net.*;
import java.util.Stack;
import Freenet.support.*;

public class DiffieHellman extends KEProtocol {

    private DHGroup group;
    private int precalc;
    private Stack precalcBuffer;

    private class PrecalcBufferFill extends Thread {
	
	public PrecalcBufferFill() {
	    setName("Diffie-Helman-Precalc");
	    setDaemon(true);
	    setPriority(MIN_PRIORITY);
	}

	public void run() {
	    while (true) {
		while (precalcBuffer.size()<precalc) {
		    precalcBuffer.push(genParams());
		}
		try {
		    Thread.sleep(500);
		} catch (InterruptedException ie) {}
	    }
	}
    }

    public DiffieHellman(DHGroup grp, RandomSource r) {
	this(grp,r,0);
    }

    public DiffieHellman(DHGroup grp, RandomSource r, int precalcCount) {
	super(r);
	this.group=grp;
	this.precalc=precalcCount;
	if (precalcCount>0) {
	    precalcBuffer=new Stack();
	    new PrecalcBufferFill().start();
	}
    }

    private BigInteger[] getParams() {
	if (precalc>0) {
	    synchronized(precalcBuffer) {
		if (!precalcBuffer.isEmpty()) 
		    return (BigInteger[])precalcBuffer.pop();
	    }
	}
	return genParams();
    }

    private BigInteger[] genParams() {
	BigInteger params[]=new BigInteger[2];
	params[0]=Util.generateLargeRandom(128,256,randomSource);
	params[1]=group.getG().modPow(params[0], group.getP());
	return params;
    }

    private BigInteger negotiate(InputStream in, OutputStream out,
				 int bits) throws IOException {
	// Use the time between negotiations as entropy
	randomSource.acceptTimerEntropy(es);


	BigInteger[] params=getParams();
	BigInteger x=params[0], X=params[1];

	Util.writeMPI(X, out);

	BigInteger Y=Util.readMPI(in);

	BigInteger key=Y.modPow(x, group.getP());

	//Use the time taken to complete the transaction as entropy
	randomSource.acceptTimerEntropy(es);
	return key;
    }

    public void negotiateKey(InputStream is, OutputStream out,
			     byte[] key, int offset, int len)
	throws IOException {
	byte[] nkey=Util.MPIbytes(negotiate(is,out,len<<3));
	Util.makeKey(nkey, key, offset, len);
    }

    public static void main(String[] args) throws Exception {
	Yarrow r=new Yarrow();

	DiffieHellman dh=new DiffieHellman(Global.DHgroupA, r);
	
	int m=45;
	Socket sock=null;
	ServerSocket ss=null;
	if (args.length==1) 
	    ss=new ServerSocket(Integer.parseInt(args[0]));
	long start=0;
	if (start==0) start=System.currentTimeMillis();
	if (args.length==1) {
	    sock=ss.accept();
	} else
	    sock=new Socket(args[0], Integer.parseInt(args[1]));
	
	InputStream in=sock.getInputStream();
	PrintStream out=new PrintStream(sock.getOutputStream());
	
	byte[] b=new byte[16];
	for (int g=0; g<m; g++) {
	    dh.negotiateKey(in, out, b, 0, b.length);
	    for (int i=0; i<b.length; i++) {
		String s=Integer.toHexString(b[i]);
		if (s.length()>1)
		    System.err.print(s.substring(s.length()-2, s.length()));
		else
		    System.err.print('0'+s);
	    }
	    System.err.println();
	    
	}
	System.out.println((System.currentTimeMillis()-start)/(double)m);
    }
}
