package Freenet.crypt;
/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.
*/

import java.io.*;

/**
 * Implements a Java InputStream that encrypts the substream on the way in.
 * This differs from CipherInputStream, which is decrypting an already
 * encrypted source
 */
public class EncipherStream extends InputStream {

    static final int BUFFER_SIZE=65536;
    protected InputStream in;
    protected PCFBMode ctx;

    public EncipherStream(InputStream src, BlockCipher c) {
	in=(src instanceof BufferedInputStream ? src :
	    new BufferedInputStream(src, BUFFER_SIZE));
	ctx=new PCFBMode(c);
    }

    public int available() throws IOException {
	return in.available();
    }

    public void close() throws IOException {
	in.close();
    }

    public boolean markSupported() {
	return false;
    }

    public int read() throws IOException {
	int rv=in.read();
	return (rv==-1 ? -1 : ctx.encipher(rv));
    }
}
