package Freenet.crypt;

import java.math.BigInteger;

/**
 * This class contains global public keys used by Freenet.  These 
 * include the Diffie-Hellman key exchange modulus, DSA groups, and 
 * any other future values
 */
public final class Global {
    
    public static final DSAGroup 
    /* -- DSA Group A -----------------------------------
     * For use in KSKs 
     * 
     * DSA modulus (|p|=1024 |q|=160 |g|=1022)
     *
     * Generation seeds:
     *
     * S=c4ef659a cb213aef 6e8cbff5 219af70a 
     *   64d9d329 d5fc9872 7678d258 8cc5a73b
     * C=154
     * N=205523667749658222872393179600727299639115513849
     */
	DSAgroupA = new DSAGroup(
	 new BigInteger(                              /* p */
	   "b9850e5e9607d50d000000000000000000000000000000000" + 
	   "00000002cdc65f1e9a7dccb571627333dd0520bf0deb206d7" +
	   "c2937330a7d6e73cec4928b172c7e8ea04cc075d18db1340d" +
	   "ac2065cbce69c5ff20b4bca2d89d2932204149a3b6811be27" +
	   "458e7d2518edf9bf4417acb1e79243fe6ae1eac68cef6d655" +
	   "43c47c1f795", 16),
	 new BigInteger(                             /* q */
	   "cfabfbd9fa4661010d9d11d0c381bb574da72667",16),
	 new BigInteger(                             /* g */
	   "2668d2935bdd27dad0a1f469c69c6f7e7bd5a3ea73adc6bc0" +
	   "a781c0a276993a0cdbb575635423744dd2e2fbd7e962ac5b4" +
	   "b79632f030ddef166c53cb002f692e2fd927f17e3e6bd404f" + 
	   "573207557972c630c01e6cc8b37fb348ad2686f4b4e3e681d" +
	   "9ced93cde9f30a2f17380204274141dce60c6151ef1b7acd0" +
	   "39ab1227fcd", 16)),

    /* -- DSA Group B -----------------------------------
     * Used in SVKs if the Storable.Group field is unspecified
     * 
     * DSA modulus (|p|=1024 |q|=160 |g|=1023)
     *
     * Generation seeds:
     *
     * S=a6af7e8c fad3503e 20fe4dd7 3a9f574e
     *   dee8a3c7 ee819adb 837d0d8c 6a263d78
     * C=166
     * N=841824943102600080885322463644579019321817144754169
     */
	DSAgroupB = new DSAGroup(
	 new BigInteger(                              /* p */
	   "c9381f278f7312c7fffffffffffffffffffffffffffffffff" +
	   "fffffffa8a6d5db1ab21047302cf6076102e67559e1569484" +
	   "6e3c7ceb4e18b6c652aedcfb337af057bdc12dcfc452d3ae4" +
	   "cfc5c3b7586804d4983bd5370db5512cf313e9a2c9c138c60" +
	   "2901135c4cfbcbe92d29fe744831f63e3273908c4f62f2129" +
	   "1840350f1e5",16),
	 new BigInteger(                             /* q */
	   "c88fa2a0b1e70ba3876a35140fddce3c683706ad", 16),
	 new BigInteger(                             /* g */
	   "65d3ccb70df16dc08822be40736bf951383f6c03ddfd51c1a" +
	   "41627fafb2b7f74a1e65ade0ab9f7c189c497cfb6fe6e9e7b" +
	   "a4160d7fd15bae68bff0e4a96f412e85924bcc89fee431406" +
	   "13afd124f425f891a2d3022f0a0444692e510fc5310360a21" +
	   "e3f729ab93f2ad81b0bbe27d86bc65cf385036969ede2473e" +
	   "6017df36d12",16));

    public static final DHGroup 
    /* -- Diffie-Hellman Group A ----------------------------
     * For use in internode symmetric-cipher key exchange
     * 
     * Diffie-Hellman KE modulus (|p|=1024, g=2)
     * 
     * Taken from the IPsec standard
     */
	DHgroupA = new DHGroup(
         new BigInteger(
           "FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD1"+
	   "29024E088A67CC74020BBEA63B139B22514A08798E3404DD"+
	   "EF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245"+
	   "E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7ED"+
	   "EE386BFB5A899FA5AE9F24117C4B1FE649286651ECE65381"+
	   "FFFFFFFFFFFFFFFF", 16),
	 Util.TWO);

    public static void main(String[] args) {
	System.err.println(DSAgroupA.toString() + '\t' + 
			   DSAgroupA.fingerprintToString());
	System.err.println(DSAgroupB.toString() + '\t' + 
			   DSAgroupB.fingerprintToString());
	System.err.println(DHgroupA.toString() + '\t' + 
			   DHgroupA.fingerprintToString());
    }
}
