package Freenet.crypt;

import java.math.BigInteger;
import java.io.*;

/**
 * Describes a general key pair system with support for multiple-value
 * keys.
 */
public abstract class KeyPair extends CryptoKey {

    protected BigInteger[] x, y;  // java 1.1 compatibility hack
                                  // -- removed final

    public KeyPair(BigInteger priv[], BigInteger pub[], CryptoKey dependent) {
	super(dependent);
	x= priv==null ? new BigInteger[0] : priv;
        y= pub==null  ? new BigInteger[0] : pub;
    }
	
    public KeyPair(BigInteger priv[], BigInteger pub[]) {
	this(priv, pub, null);
    }

    protected static BigInteger[][] 
	readKeys(DataInputStream i) throws IOException {

	int pubcomps=i.readUnsignedByte();
	int privcomps=i.readUnsignedByte();

	BigInteger x[]=new BigInteger[privcomps];
	BigInteger y[]=new BigInteger[pubcomps];

	for (int j=0; j<y.length; j++) 
	    y[j]=Util.readMPI(i);
	for (int j=0; j<x.length; j++) 
	    x[j]=Util.readMPI(i);
	
	return new BigInteger[][] {x, y};
    }
 
    public void write(DataOutputStream o, String clazz) throws IOException {
	super.write(o, clazz);
	
	o.write(y.length);
	o.write(x.length);
	for (int j=0; j<y.length; j++) 
	    Util.writeMPI(y[j],o);
	for (int j=0; j<x.length; j++) 
	    Util.writeMPI(x[j],o);
    }

    public BigInteger[] getPublicComponents() {
	return y;
    }

    public BigInteger[] getPrivateComponents() {
	return x;
    }

    public byte[] fingerprint() {
	return fingerprint(getPublicComponents());
    }
}	

