package Freenet.crypt;

import java.math.BigInteger;
import java.io.*;
import java.util.Random;

public class RSASignature {

    private final BigInteger m;

    public RSASignature(InputStream in) throws IOException {
	m=Util.readMPI(in);
    }

    /**
     * Parses a DSA Signature pair from a string, where r and s are 
     * in unsigned hex-strings, separated by a comma
     */
    public RSASignature(String sig) {
	m=Util.byteArrayToMPI(Util.hexToBytes(sig));
    }

    public void write(OutputStream o) throws IOException {
	Util.writeMPI(m, o);
    }

    public RSASignature(BigInteger m) {
	this.m=m;
    }

    public BigInteger getS() {
	return m;
    }

    public String toString() {
	return m.toString(16).toLowerCase();
    }
		  
}
