package Freenet.crypt;

import java.io.*;

/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.
*/

/**
 * Assuming you have a sufficiently long file containing random data that 
 * you wish to use (i.e. a unix random device), this wraps that file
 * into the RandomSource interface
 */
public class RandFile extends RandStream {
    
    public RandFile(String filename) {
	try {
	    stream=new DataInputStream(new FileInputStream(filename));
	} catch (Exception e) {
	    stream=null; // FORCES fallback 
	}
    }

    public static void main(String[] args) throws Exception {
	//      System.getProperties().list(System.out);
	RandomSource r=new RandFile("/dev/random");
	byte[] b=new byte[1024];
	for (int i=0; i<24; i++) {
	    System.out.println(Long.toHexString(r.nextLong()));

	}
	r.close();
    }
}
