package Freenet.crypt.ciphers;

import Freenet.Core;
import Freenet.crypt.BlockCipher;
import Freenet.support.Logger;
import java.security.InvalidKeyException;

/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.
*/

/**
 * Interfaces with the Twofish AES candidate to implement the Twofish
 * algorithm
 */
public class Twofish implements BlockCipher {
    private Object sessionKey;
    private int keysize;

    public Twofish(int keysize) {
	if (! (keysize == 64 ||
	       keysize == 128 ||
	       keysize == 192 ||
	       keysize == 256))
	    throw new RuntimeException("Invalid keysize");
	this.keysize=keysize;
    }

    public Twofish() {
	this(128);
    }

    public int getBlockSize() {
	return 128;
    }

    public int getKeySize() {
	return keysize;
    }

    public void initialize(byte[] key) {
	try {
	    byte[] nkey=new byte[keysize>>3];
	    System.arraycopy(key, 0, nkey, 0, nkey.length);
	    sessionKey=Twofish_Algorithm.makeKey(nkey);
	} catch (InvalidKeyException e) {
	    e.printStackTrace();
	    Core.logger.log(this,"Invalid key",Logger.ERROR);
	}
    }

    public byte[] encipher(byte[] block) {
	return Twofish_Algorithm.blockEncrypt(block, 0, sessionKey);
    }

    public byte[] decipher(byte[] block) {
	return Twofish_Algorithm.blockDecrypt(block, 0, sessionKey);
    }
}
