package Freenet.fs;

import java.io.*;
import Freenet.FieldSet;
import Freenet.Key;
import Freenet.crypt.*;
import Freenet.crypt.ciphers.Twofish;

public class DataDescriptor extends FSElement {

    protected long timestamp;
    protected transient DatastoreFS fs;

    public DataDescriptor(String key) {
	this(key, System.currentTimeMillis());
    }

    public DataDescriptor(long t) {
	timestamp=t;
    }

    public DataDescriptor(String key, long t) {
	this.key=key;
	timestamp=t;
    }

    public static FSElement read(DataInputStream f) throws IOException {
	long t=f.readLong();
	DataDescriptor d=new DataDescriptor(t);
	return d;
    }

    public void write(DataOutputStream f) throws IOException {
	super.write(this, f);
	f.writeLong(timestamp);
    }

    /**
     * Attempts to write the Data to the datastore.  If successful, true 
     * returned.  If unsucessful because the datastore is full, false
     * is returned.  
     */
    public boolean write(DatastoreFS fs, InputStream data, FieldSet storables,
			 long bytes) throws IOException {
	this.fs=fs;
	
	return  storeData(this, data, bytes);

    }

    protected boolean storeData(FSElement e, InputStream data, long bytes) 
	throws IOException {

	WriteToken t=fs.create(bytes);
	if (t==null)
	    return false;

	fs.index(t, e);

	OutputStream f=t.getStream();

	long len=bytes;
	byte[] buffer=new byte[65536];
	int rc=0;

	do {
	    rc=data.read(buffer, 0, (int)Math.min(len, buffer.length));
	    if (rc>0) {
		len-=rc;
		f.write(buffer, 0, rc);
	    }
	} while (rc!=-1 && len!=0);
	f.close();
	fs.commit(t, e);
	return true;
    }
}
