package Freenet.fs;

import java.io.*;
import java.util.*;
import Freenet.crypt.BlockCipher;

public class Directory {
    protected byte[] dsKey=new byte[0];
    private Hashtable directory;
    private boolean dirty=false;
    private Vector freeList;
    private File dsdf, dsdfb;
    private long dsSize;

    public Directory(long dsSize) {
	this.dsSize=dsSize;
	directory=new Hashtable();
	buildFreeList();
    }

    public Directory(File f, long dsSize) throws IOException {
	this.dsSize=dsSize;
	dsdf=f;
	dsdfb=new File(dsdf.getName()+".tmp");
	try {
	    DataInputStream dis=new DataInputStream(new FileInputStream(f));
	    readDirectory(dis);
	} catch (Exception e) {
	    e.printStackTrace();
	    directory=new Hashtable();
	}
	buildFreeList();

    }

    public String[] keys() {
	Vector keys=new Vector(directory.size());
	for (Enumeration enum=directory.keys(); 
	     enum.hasMoreElements();) {
	    keys.addElement(enum.nextElement());
	}
	String[] rv=new String[keys.size()];
	keys.copyInto(rv);
	return rv;
    }

    protected void reset(Random r) {
	dsKey=new byte[0];
	directory=new Hashtable();
	buildFreeList();
	if (r!=null) {
	    dsKey=new byte[16];
	    r.nextBytes(dsKey);
	}
	dirty=true;
    }

    protected void readDirectory(DataInputStream f) throws IOException {
	byte[] verStr=new byte[9];
	f.readFully(verStr);
	if (!new String(verStr).equals("VERSION 5"))
	    throw new IOException ("Not a version 5 datastore.");

	char keyLen=f.readChar();
	
	if (keyLen>0) {
	    dsKey=new byte[keyLen];
	    f.readFully(dsKey);
	}

	directory=new Hashtable();
	int itemCount = f.readInt();
	for (int i=0; i<itemCount; i++) {
	    FSElement dd=FSElement.read(f);
	    directory.put(dd.getKey(), dd);
	}
	f.close();
	dirty=false;
    }

    protected static byte[] verString=new byte[9];
    
    static {
	for (int i=0; i<9; i++) 
	    verString[i]=(byte)"VERSION 5".charAt(i);
    }

    protected void writeDirectory(File dsdf, Hashtable directory) throws IOException {
	DataOutputStream f=new DataOutputStream(new FileOutputStream(dsdf));
	f.write(verString);
	f.writeChar((char)dsKey.length);
	f.write(dsKey);
	synchronized(directory) {
	    int size=0;
	    for (Enumeration enum=directory.keys(); 
		 enum.hasMoreElements();) {
		if (((FSElement)directory.get(enum.nextElement())).state()==
		    FSElement.COMMITED)
		    size++;
	    }
	    f.writeInt(size);
	    for (Enumeration enum=directory.keys(); 
		 enum.hasMoreElements();) {
		FSElement e=(FSElement)directory.get(enum.nextElement());
		if (e.state()==FSElement.COMMITED)
		    e.write(f);
	    }
	}
	f.close();
    }

    public boolean isDirty() {
	return dirty;
    }

    public void sync() {
	if (isDirty()) 
	    try {
		String base=dsdf.getName();
		writeDirectory(dsdfb, directory);	
		dsdfb.renameTo(dsdf);
		dirty=false;
	    } catch (IOException e) {
		e.printStackTrace();
	    }
    }

    protected void buildFreeList() {
	Vector rangeVect=new Vector();
	synchronized(directory) {
	    int i=0;
	    for (Enumeration enum=directory.keys(); enum.hasMoreElements();) {
    		FSElement fe=(FSElement)directory.get(enum.nextElement());
		long[][] r=fe.getRanges();
		for (int j=0; j<r.length; j++) 
		    rangeVect.addElement(r[j]);
	    }
	}
	long[][] ranges=new long[rangeVect.size()][2];
	rangeVect.copyInto(ranges);

	sort(ranges);
	long s=0;
	Vector fl=new Vector();
	for (int i=0; i<ranges.length; i++) {
	    if (s<ranges[i][0]) 
		fl.addElement(new long[] {s, ranges[i][0]-1});
	    s=ranges[i][1]+1;
	}
	if (s<dsSize) 
	    fl.addElement(new long[] {s, dsSize-1});
	sortFree(fl);
	freeList=fl;
    }

    public static void sort(long[][] a) {
	for (int j=1; j<a.length; j++) {
	    long[] key=a[j];
	    int i=j-1;
	    while (i>-1 && a[i][0] > key[0]) {
		a[i+1]=a[i];
		i=i-1;
	    }
	    a[i+1]=key;
	}
    }

    public long free() {
	long total=0;
	for (Enumeration enum=directory.elements();
	     enum.hasMoreElements();) {
	    long[] range=(long[])enum.nextElement();
	    total+=size(range);
	}
	return total;
    }
	     
    protected static long size(long[] range) {
	return (range[1] - range[0]) +1;
    }

    public static void sortFree(Vector a) {
	for (int j=1; j<a.size(); j++) {
	    long[] key=(long[])a.get(j);
	    int i=j-1;
	    while (i>-1 && size((long[])a.get(i)) > size(key)) {
		a.setElementAt(a.get(i), i+1);
		i=i-1;
	    }
	    a.setElementAt(key,i+1);
	}
    }

    public void free(Object key) throws FileNotFoundException {
	FSElement fe=(FSElement)directory.get(key);
	if (fe==null) 
	    throw new FileNotFoundException(key.toString());
	addToFreeList(fe.getRanges());
	directory.remove(key);
	dirty=true;
	sync();
    }

    public long[][] allocate(long bytes) {
	try {
	    Vector res=new Vector(freeList.size());
	    allocate(bytes, freeList, res);
	    long[][] ranges=new long[res.size()][2];
	    res.copyInto(ranges);
	    return ranges;
	} catch (NullPointerException n) {
	    n.printStackTrace();
	    buildFreeList();
	    return null;
	}
    }

    protected static void allocate(long bytes, Vector freeList, Vector res) {
	if (bytes==0) {
	    res.add(new long[] {0L,0L});
	    return;
	}
	int i=0;
	long f[]=null, d=0;
	for (; i<freeList.size(); i++) {
	    f=(long[])freeList.elementAt(i);
	    d=size(f);
	    if (d >= bytes) {
		long[] rptr=new long[] {f[0], (f[0]+bytes) - 1 };
		f[0]+=bytes;
	    System.err.println(f[0]+"->"+f[1]);

		if (f[0] > f[1])
		    freeList.removeElementAt(i);
		res.add(rptr);
		return;
	    }
	}
	long[] rptr=new long[] {f[0], f[1], d};
	res.add(rptr);
	freeList.removeElementAt(i-1);
	bytes-=d;
	allocate(bytes, freeList, res);
    }
		
    private void addToFreeList(long[][] ranges) {
	for (int i=0; i<ranges.length; i++) 
	    addToFreeList(ranges[i]);
    }

    private void addToFreeList(long[] range) {
	for (Enumeration enum=freeList.elements(); 
	     enum.hasMoreElements();) {
	    long[] l=(long[])enum.nextElement();
	    if (l[1]+1==range[0]) {
		l[1]=range[1];
		return;
	    } else if (l[0]-1==range[1]) {
		l[0]=range[0];
		return;
	    }
	}
	freeList.addElement(range);
	sortFree(freeList);
    }
	
    public void index(FSElement e) throws IOException {
	if (directory.get(e.getKey())!=null)
	    throw new IOException("File already exists");
	e.setState(FSElement.UNCOMMITED);
	directory.put(e.getKey(), e);
    }

    public void commit(FSElement e) {
	e.setState(FSElement.COMMITED);
	dirty=true;
    }

    public void rollback(WriteToken t, FSElement e) {
	addToFreeList(t.ranges);
	directory.remove(e.getKey());
	e.setState(FSElement.UNCOMMITED);
    }

    public FSElement get(String key) {
	return (FSElement)directory.get(key);
    }

    public long[][] getRanges(Object key) {
	FSElement e=(FSElement)directory.get(key);
	return e.getRanges();
    }

    public void listFree() {   
	System.out.println("Free: ");
	long total=0;
	for (Enumeration enum=freeList.elements(); 
	     enum.hasMoreElements();) {
	    long[] l=(long[])enum.nextElement();
	    System.out.println(l[0]+"\t-> "+l[1]);
	    total+=(l[1]-l[0])+1;
	}
	System.out.println(total+" bytes free.");
    }

    protected byte[] setupCipher(BlockCipher c, long start, long end) {
	byte[] iv=new byte[16];
	for (int i=0; i<8; i++)
	    iv[i] = (byte)((start >> (64-(i+1)*8)) & 0xff);
	for (int i=0; i<8; i++)
	    iv[i+8] = (byte)((end >> (64-(i+1)*8)) & 0xff);
	c.initialize(dsKey);
	return iv;
    }
	

    public void list() {
	System.out.println("Directory: ");
	long total=0, count=0;
	for (Enumeration enum=directory.keys(); 
	     enum.hasMoreElements();) {
	    FSElement dsi=(FSElement)directory.get(enum.nextElement());
	    total+=dsi.length();
	    count++;
	    System.out.println(dsi.length()+"\t"+dsi.getKey());
	    System.out.print('\t');
	    System.out.println(rangeList(dsi.ranges));
	}
	System.out.println("Total: "+count+" items, "+total+" bytes");
    }

    public static String rangeList(long[][] ranges) {
	StringBuffer b=new StringBuffer();
	for (int i=0; i<ranges.length; i++) {
	    b.append(ranges[i][0]).append("->").append(ranges[i][1]);
	    if (i+1 < ranges.length)
		b.append(' ');
	}
	return b.toString();
    }


    public static void main(String[] args) throws Exception {
	Vector fl=new Vector();
	fl.addElement(new long[] {0, 4});
	fl.addElement(new long[] {7, 9});
	fl.addElement(new long[] {15, 36});
	sortFree(fl);
	
	Vector v=new Vector();
	allocate(25,fl,v);
	
	for (int i=0; i<v.size(); i++) 
	    System.err.print(((long[])v.elementAt(i))[0]+","+
			     ((long[])v.elementAt(i))[1]+","+
			     ((long[])v.elementAt(i))[2]+" ");
	System.err.println();
	for (int i=0; i<fl.size(); i++) 
	    System.err.print(((long[])fl.elementAt(i))[0]+","+
			     ((long[])fl.elementAt(i))[1]+" ");

    }
}	    
