package Freenet.fs;

import java.io.*;
import java.lang.reflect.*;

public abstract class FSElement {

    public static final int 
	UNCOMMITED = 0,
	COMMITED = 1;
    
    protected String key;
    protected int state;
    protected long[][] ranges;
    
    public void setState(int state) {
	this.state=state;
    }

    public int state() {
	return state;
    }

    public long[][] getRanges() {
	return ranges;
    }

    public long length() {
	long total=0;
	for (int i=0; i<ranges.length; i++) 
	    total+=(ranges[i][1] - ranges[i][0])+1;
	return total;
    }

    public Object getKey() {
	return key;
    }

    public abstract void write(DataOutputStream out) throws IOException;

    protected void write(FSElement e, DataOutputStream dos) 
	throws IOException {
	dos.writeUTF(e.getClass().getName());
	dos.writeUTF(key);
	dos.writeChar((char)ranges.length);
	for (int i=0; i<ranges.length; i++) {
	    dos.writeLong(ranges[i][0]);
	    dos.writeLong(ranges[i][1]);
	}
    }


    public static FSElement read(DataInputStream in) throws IOException {
	String className=in.readUTF();
	try {
	    Class clazz=Class.forName(className);
	    Method m=clazz.getMethod("read", 
				     new Class[] {DataInputStream.class});
	    String key=in.readUTF();
	    char rangeCount=in.readChar();
	    long[][] ranges=new long[rangeCount][2];
	    for (int i=0; i<rangeCount; i++) {
		ranges[i][0]=in.readLong();
		ranges[i][1]=in.readLong();
	    }
	    FSElement fse=(FSElement)m.invoke(null, new Object[] {in});
	    fse.setState(FSElement.COMMITED);
	    fse.ranges=ranges;
	    fse.key=key;
	    return fse;
	} catch (Exception e) {
	    e.printStackTrace();
	}
	return null;
    }
}
