package Freenet.fs;

import java.io.*;
import Freenet.FieldSet;
import Freenet.support.io.WriteOutputStream;


public class FieldSetDescriptor extends FSElement {
    protected byte[] data;

    public FieldSetDescriptor() {}

    public FieldSetDescriptor(String k) {
	this.key=k;
    }

    public FieldSetDescriptor(String key, FieldSet s) {
	this(key);

	//Write the storables as a file
	try {
	    ByteArrayOutputStream bos=new ByteArrayOutputStream();
	    WriteOutputStream p=new WriteOutputStream(bos);
	    s.writeFields(p, "End", '\n', '=', '.');
	    p.flush();
	    data=bos.toByteArray();
	} catch (IOException e) {
	    e.printStackTrace();
	}
    }

    public static FSElement read(DataInputStream dis) throws IOException {
	return new FieldSetDescriptor();
    }

    public void write(DataOutputStream dos) throws IOException {
	super.write(this, dos);
    }
}
