package Freenet.fs;

import java.io.*;

public class LimitInputStream extends InputStream {
    protected long length, bytesRead;
    protected boolean closed;
    protected ReadLock rl;
    protected RandomAccessFile f;
    
    public LimitInputStream(ReadLock rl, RandomAccessFile f, long len) {
	this.rl=rl;
	this.f=f;
	length=len;
    }

    public int read() throws IOException {
	if (closed) throw new IOException("Stream closed");
	if (length < bytesRead) {
	    int rv=f.read();
	    bytesRead++;
	    if (bytesRead == length) 
		rl.unlock();
	    return rv;
	} else {
	    rl.unlock();
	    return -1;
	}
    }

    public int read(byte[] bytes, int off, int len) throws IOException {
	if (closed) throw new IOException("Stream closed");
	if (bytesRead == length) {
	    rl.unlock();
	    return -1;
	}

	if (len + bytesRead > length) 
	    len = (int)(length - bytesRead);

	int rv=f.read(bytes, off, len);
	if (rv!=-1) {
	    bytesRead+=rv;
	    if (bytesRead == length);
	    rl.unlock();
	}
	return rv;
    }
    
    public int available() {
	return (int) (length - bytesRead);
    }

    public void close() {
	rl.unlock();
	closed=true;
    }
}
