package Freenet.fs;

import java.io.*;

public class LimitOutputStream extends OutputStream {
    protected long length, bytesWritten;
    protected boolean closed;
    protected WriteLock wl;
    protected RandomAccessFile f;
    
    public LimitOutputStream(WriteLock wl, RandomAccessFile f, long len) {
	this.wl=wl;
	this.f=f;
	length=len;
	bytesWritten=0;
    }

    public void write(int i) throws IOException {
	if (closed) throw new IOException("Stream closed");
	if (length < bytesWritten) {
	    f.write(i);
	    bytesWritten++;
	    if (bytesWritten==length)
		wl.unlock();
	    synchronized(f) {
		f.notifyAll();
	    }

	} else {
	    throw new IOException("Attempt to write past lock boundary on lock "+wl.getStart()+"->"+wl.getEnd()+" ("+f.getFilePointer()+")");
	}
    }

    public void write(byte[] bytes, int off, int len) throws IOException {
	if (closed) throw new IOException("Stream closed");
	if (bytesWritten+len > length) {
	    throw new IOException("Attempt to write past lock boundary on lock "+wl.getStart()+"->"+wl.getEnd()+" (+"+len+" "+(f.getFilePointer()+len)+")");
	}
	f.write(bytes, off, len);
	bytesWritten+=len;
	if (bytesWritten==length) 
	    wl.unlock();
	synchronized(f) {
	    f.notifyAll();
	}
    }
    
    public void close() {
	closed=true;
    }
}
