package Freenet.fs;

import java.io.*;

public interface Lock {

    public void unlock();

    /**
     * Get the starting byte of the lock
     */ 
    public long getStart();

    /**
     * Get the ending byte of the lock
     */ 
    public long getEnd();

    /**
     * Returns true if the lock is still active
     */
    public boolean isLocked();

    /** 
     * returns the lock type, READ or WRITE
     */
    public int getType();
    
    /**
     * Returns the mask needed to block this lock
     */
    public int getProtection();
    
    public int
	NONE    = 0x0,
	READ    = 0x1,
	WRITE   = 0x2, 
	UPGRADE = 0x3,
	ALL     = 0xf;

}
