package Freenet.fs;

import java.io.*; 
import java.util.*;

public class LockSequenceOutputStream extends OutputStream {

    protected Vector streams=new Vector(3);
    protected OutputStream current;
    protected long limit;

    public void addStream(WriteLock out) throws IOException {
	if (current==null) {
	    current=out.getStream();
	    limit=(out.getEnd() - out.getStart()) + 1;
	} else streams.addElement(out);
    }

    public void write(int i) throws IOException {
	if (limit == 0) nextStream();
	current.write(i);
	limit--;
    }

    public void write(byte[] data, int off, int len) throws IOException {
	if (limit == 0) {
	    nextStream();
	    write(data, off, len);
	    return;
	} if (len > limit) {
	    current.write(data, off, (int)limit);
	    off+=limit;
	    len-=limit;
	    limit=0;
	    if (len!=0) write(data, off, len);
	    return;
	} else {
	    current.write(data, off, len);
	    limit-=len;
	}
    }

    public void close() throws IOException {
	current.close();
	for (Enumeration enum=streams.elements(); 
	     enum.hasMoreElements();) 
	    ((OutputStream)enum.nextElement()).close();
    }

    protected void nextStream() throws IOException {
	current.close();
	WriteLock l=(WriteLock)streams.firstElement();
	current=l.getStream();
	limit=(l.getEnd()-l.getStart()) + 1;
	streams.removeElementAt(0);
    }
}
	    
