package Freenet.fs;

import java.io.*;

public class ReadLock implements Lock {
    protected DatastoreFS fs;
    protected long start, end;
    protected RandomAccessFile f;
    protected boolean locked=true;

    public ReadLock(DatastoreFS fs, long bs, long be, RandomAccessFile f) {
	this.fs=fs;
	start=bs;
	end=be;
	this.f=f;
    }

    public InputStream getStream() throws IOException {
	return fs.decrypt(this, 
			  new LimitInputStream(this, f, (end-start) + 1));
    }

    public void unlock() {
	if (locked) {
	    locked=false;
	    fs.retire(f);
	    fs.unlock(this);
	}
    }
    public long getStart() {
	return start;
    }

    public long getEnd() {
	return end;
    }

    public boolean isLocked() {
	return locked;
    }

    public int getType() {
	return READ;
    }

    public int getProtection() {
	return WRITE;
    }

    public String toString() {
	StringBuffer b=new StringBuffer();
	b.append('(').append("read").append(": ");
	b.append(getStart()).append("->").append(getEnd());
	b.append(')');
	return b.toString();
    }	
}

    
