package Freenet.fs;

import java.io.*;

public class SlidingInputStream extends InputStream {
    protected long length, bytesRead;
    protected boolean closed;
    protected SlidingLock rl;
    protected RandomAccessFile f;
    
    public SlidingInputStream(SlidingLock rl, RandomAccessFile f, long len) {
	this.rl=rl;
	this.f=f;
	length=len;
    }

    public int read() throws IOException {
	if (closed) throw new IOException("Stream closed");
	if (f.getFilePointer() < rl.getBoundary()) {
	    if (bytesRead < length) {
		int rv=f.read();
		bytesRead++;
		if (bytesRead == length) 
		    rl.unlock();
		return rv;
	    } else {
		rl.unlock();
		return -1;
	    }
	} else {
	    rl.waitForSlide();
	    return read();
	}
    }

    public int read(byte[] bytes, int off, int len) throws IOException {
	if (closed) throw new IOException("Stream closed");
	if (bytesRead == length) {
	    rl.unlock();
	    return -1;
	}

	if (len + bytesRead > length) 
	    len = (int)(length - bytesRead);
	if (f.getFilePointer() == rl.getBoundary()) 
	    rl.waitForSlide();
	if (f.getFilePointer() + len > rl.getBoundary()) 
	    len = (int)(rl.getBoundary() - f.getFilePointer());

	int rv=f.read(bytes, off, len);
	if (rv!=-1) {
	    bytesRead+=rv;
	    if (bytesRead == length)
		rl.unlock();
	}
	return rv;
    }
    
    public int available() throws IOException {
	return (int) (rl.getBoundary() - f.getFilePointer());
    }

    public void close() {
	rl.unlock();
	closed=true;
    }
}
