package Freenet.fs;

import java.io.*;

public class SlidingLock extends ReadLock {
    protected WriteLock boundary;

    public SlidingLock(DatastoreFS fs, long bs, long be, RandomAccessFile f,
		     WriteLock w) {
	super(fs, bs, be, f);
	boundary=w;
    }

    public int getProtection() {
	return NONE;
    }

    public long getBoundary() throws IOException {
	return boundary.getBoundary();
    }

    public void waitForSlide() {
	synchronized(boundary.f) {
	    try {
		boundary.f.wait();
	    } catch (InterruptedException ie) {}
	}
    }

    public InputStream getStream() throws IOException {
	return fs.decrypt(this, 
			  new SlidingInputStream(this, f, (end-start) + 1));
    }

    public String toString() {
	StringBuffer b=new StringBuffer();
	b.append('(').append("slide").append(": ");
	b.append(getStart()).append("->").append(getEnd());
	b.append(')');
	return b.toString();
    }	
}
    
