package Freenet.fs;

import java.io.*;

public class WriteLock implements Lock {
    protected int typestatus=UPGRADE, protstatus=NONE;
    protected DatastoreFS fs;
    protected long start, end;
    protected RandomAccessFile f;
    protected boolean locked=true;
    //    protected long[] freeRange;

    public WriteLock(DatastoreFS fs, long bs, long be, RandomAccessFile f
		     //, long[] freeRange
		     ) {
	//	this.freeRange=freeRange;
	this.fs=fs;
	start=bs;
	end=be;
	this.f=f;
    }

    public OutputStream getStream() throws IOException {
	f.seek(getStart());
	return fs.encrypt(this, 
			  new LimitOutputStream(this, f, (end-start) + 1));
    }

    public void unlock() {
	if (locked) {
	    locked=false;
	    try {
		f.close();
	    } catch (IOException e) {
		e.printStackTrace();
	    }
	    fs.unlock(this);
	}
    }

    long getBoundary() throws IOException {
	return f.getFilePointer();
    }

    public long getStart() {
	return start;
    }

    public long getEnd() {
	return end;
    }

    public boolean isLocked() {
	return locked;
    }

    protected void upgrade() {
	typestatus=WRITE;
	protstatus=ALL;
    }

    public int getType() {
	return typestatus;
    }

    public int getProtection() {
	return protstatus;
    }
    
    public long getPos() throws IOException {
	return f.getFilePointer();
    }

    public String toString() {
	StringBuffer b=new StringBuffer();
	b.append('(').append("write").append(": ");
	b.append(getStart()).append("->").append(getEnd());
	b.append(')');
	return b.toString();
    }	
}
