package Freenet.keys;
import Freenet.crypt.*;
import Freenet.support.Fields;
import Freenet.support.io.*;
import Freenet.message.DataSend;
import Freenet.*;
import java.io.*;

public class CHK extends Key {

    public static int keyNumber = 0x0301;

    public CHK(byte[] keyval) throws KeyException {
	super(keyval);
	if (val.length != 23 || (val[21] & 0xff) != (keyNumber >> 8 & 0xff) || (val[22] & 0xff) != (keyNumber & 0xff))
	    throw new KeyException("Byte array does not contain a CHK");
    }

    public VerifyingInputStream verifyStream(InputStream data, 
					     FieldSet storables,
					     long dataLength)
	throws DataNotValidIOException {
	try {
	    String s = storables == null ? null : storables.get("PartSize");
	    SHA1 dig = new SHA1();
	    long partSize = s == null ? 0 : Fields.stringToLong(s);
	    long sizeBound = (1 << (val[20] & 0x3F));
	    if (partSize != 0) { // deduct hash length from partSize
		partSize -= dig.digestSize() >> 3;
		if (sizeBound != 1 && partSize > sizeBound)
		    throw new DataNotValidIOException(Presentation.CB_BAD_KEY);
	    } else {
		if (sizeBound != 1 && dataLength > sizeBound)
		    throw new DataNotValidIOException(Presentation.CB_BAD_KEY);
	    }
	    return new ProgressiveHashInputStream(data,partSize,dataLength,
						  new SHA1(),val);
	} catch (DataNotValidIOException e) {
	    //	    e.printStackTrace(Core.logger.getOut());
	    throw e;
	} catch (Exception e) {
	    e.printStackTrace(Core.logger.getOut());
	    throw new DataNotValidIOException(Presentation.CB_BAD_KEY);
	}
    }

    public boolean isCachable() {
	return true;
    }

    public String toString() {
	return Fields.bytesToHex(val,0,23);
    }

}





