package Freenet.keys;

import Freenet.*;
import Freenet.support.Fields;
import Freenet.support.io.VerifyingInputStream;
import Freenet.support.io.ControlInputStream;
import Freenet.crypt.SHA1;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
/**
 * KHK stands for Keyword Hash Key. This is the most simple kind of key
 * where the value is simply the hash of a keyword, and has no relation 
 * to the data.
 * 
 * KHKs are keyType 01 01.
 * @author oskar
 **/
public class KHK extends Key {

    public static void main(String[] agrs) {
	KHK hello = makeKHK("hello");
	System.out.println("KHK for \"hello\" : " + hello);
	KHK freenet = makeKHK("Freenet");
	System.out.println("KHK for \"Freenet\" : " + freenet);	
    }

    public static int keyNumber = 0x0101;

    /**
     * Constructs a KHK by hashing a keyword string.
     * @param keyword The keyword string that names this key.
     **/
    public static KHK makeKHK(String keyword) {
	try {
	    SHA1 dig = new SHA1();
	    byte[] bs = keyword.getBytes("UTF8");
	    dig.update(bs, 0, bs.length);
	    byte[] keyval = new byte[22];
	    dig.digest(false, keyval, 0);
	    keyval[20] = (byte) (keyNumber>>8 & 0xFF);
	    keyval[21] = (byte) (keyNumber & 0xFF);
	    return new KHK(keyval);
	} catch (UnsupportedEncodingException e) {
	    throw new RuntimeException("KHKs require UTF8 encoding");
	}
    }

    /**
     * Wraps a KHK around this byte array.
     * @param keyval The buffer
     * @throws KeyException if the contents of the array are not a KHK
     **/
    public KHK(byte[] keyval) throws KeyException {
	super(keyval);
	if (val.length != 22 || val[20] != (keyNumber>>8 & 0xFF) || val[21] != (keyNumber & 0xFF))
	    throw new KeyException("byte array did not contain KHK");
    }

    /**
     * Streams will always verify for KHKs, unless the final control char 
     * is something other then CB_OK.
     * 
     * I might add a CRC32 with the checksum in a Storables some day.
     * (actually I doubt it since the self checking KSK replaces this.
     **/
    public VerifyingInputStream verifyStream(InputStream data,
					     FieldSet storables,
					     long dataLength) {
	return new ControlInputStream(data,0,dataLength);
    }

    /**
     * Returns whether to cache the data for this key on this node.
     *
     * As of build 158 the implementation of isCachable in KHK always 
     * returns false. Use KSKs instead.
     **/
    public boolean isCachable() {
	return false;
    }

    /**
     * Prints the the key in the form expected by Key.readKey(),
     * KHK/&lt;hex value&gt;
     **/
    public String toString() {
	return Fields.bytesToHex(val,0,22);
    }
}
