package Freenet.keys;

import Freenet.*;
import Freenet.support.Fields;
import Freenet.support.io.*;
import Freenet.crypt.*;
import java.math.BigInteger;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Random;

/**
 * SVK stands for Signature Verifiable Key.  This key is composed using a 
 * DSS public key, and is thus verifyable by any node in the network.
 * 
 * KSKs are keyType 02 02. 
 * @author Scott G. Miller
 **/
public class KSK extends SVK {

    public static void main(String[] agrs) {
	FieldSet storables=new FieldSet();
       	KSK hello = makeKSK("hello", storables);
	System.out.println("KSK for \"hello\" : " + hello);
	System.out.println("Public key : "+storables.get("Public-key"));
	KSK freenet = makeKSK("Freenet", storables);
	System.out.println("KSK for \"Freenet\" : " + freenet);	
	System.out.println("Public key : "+storables.get("Public-key"));
    }

    public static int keyNumber = 0x0202;

    /**
     * Constructs a KSK (which is a special case of an SVK)
     * by hashing a keyword string and using it as the private key
     * in an SVK.
     *
     * @param keyword The keyword string that names this key.
     * @param storables A FieldSet that the public key of a newly generated
     * KSK can be stored. 
     **/
    public static KSK makeKSK(String keyword, FieldSet storables) {
	byte[] keytmp=Util.hashString(new SHA1(), keyword);
	DSAKeyPair keyPair=new DSAKeyPair(Util.byteArrayToMPI(keytmp),
					  Global.DSAgroupA);
	byte[] keyVal=makeSVK(keyPair, null, storables, keyNumber);
	return new KSK(keyVal, keyPair);
    }

    /**
     * Wraps a KSK around this byte array.
     * @param keyval The buffer
     * @throws KeyException if the contents of the array are not a SVK
     **/
    public KSK(byte[] keyval) throws KeyException {
	this(keyval, null);
    }

    /**
     * Wraps a KSK around this byte array.
     * @param keyval The buffer
     * @param kp A DSAKeyPair (if known)
     * @throws KeyException if the contents of the array are not a SVK
     **/
    public KSK(byte[] keyval, DSAKeyPair kp) throws KeyException {
	super(keyval, keyNumber, kp);
    }

    /**
     * Returns whether to cache the data for this key on this node.
     *
     * The implementation of isCachable in SVK always returns true.
     **/
    public boolean isCachable() {
	return true;
    }

    public void sign(byte[] hash, Random r, FieldSet storables) {
	super.sign(hash, r, storables);
    }

    public VerifyingInputStream verifyStream(InputStream data,
					     FieldSet storables,
					     long docLength)
	throws DataNotValidIOException {
	return super.verifyStream(data, storables, docLength, keyNumber);
    }

    /**
     * Prints the the key in the form expected by Key.readKey(),
     * KHK/&lt;hex value&gt;
     **/
    public String toString() {
	return Fields.bytesToHex(val,0,23);
    }
}
