/*
   This code is part of the Java Adaptive Network Client by Ian Clarke. 
   It is distributed under the GNU Public Licence (GPL) version 2.  See
   http://www.gnu.org/ for further details of the GPL.

   Explanation of Code Versions: 
     0.0.0      = Initial Description
     0.0.1      = API Specified
     0.x (x>0)  = Partial Implementation
     x.0 (x>0)  = Operational
		
   Requires Classes: Node (1.0)
                     Address (1.0)
		     Message (1.0)

*/


/**
 * This is the DataInsert message
 *
 * @see Node
 * @see Address
 * @author Brandon Wiley (blanu@uts.cc.utexas.edu)
 * @author Ian Clarke (I.Clarke@strs.co.uk)
 * @author oskar
 **/

package Freenet.message;
import java.io.*;
//import java.net.*;
import Freenet.*;
import Freenet.node.*;
import Freenet.support.*;
import Freenet.support.io.DataNotValidIOException;

public class DataInsert extends DataSend
{

    public static final String messageName = "DataInsert";

    public DataInsert(long idnum, long htl,long depth, FieldSet otherfields)
	throws BadAddressException {
	super(idnum, htl, depth,otherfields);
    }

    public DataInsert(long idnum, long htl,long depth,  FieldSet otherfields, 
		      InputStream data)
	throws BadAddressException {
	super(idnum, htl, depth, otherfields);
	this.in = data;
    }


    public DataInsert(RawMessage raw)
	throws InvalidMessageException, BadAddressException {
	super(raw);
    }
    
    public RawMessage toRawMessage(Presentation t)
    {
	RawMessage raw=super.toRawMessage(t);
	raw.messageType="DataInsert";
	//	System.out.println(raw.toString());
	return raw;
    }
    

    public SendDone getSendDone(InputStream in) {
	return new InsertSendDone(in);
    }

    private class InsertSendDone extends SendDone {

	public InsertSendDone(InputStream in) {
	    super(DataInsert.this.id,in);
	}

	protected MessageMemory sendFinished(Node n, KeyedMM kmm) {
	    try {
		kmm.storeData.resetDataSource(true);
		if (kmm.dataCon == null || !(kmm.dataCon.isOpen())) {
		    kmm.dataCon = n.makeConnection(kmm.dataref);
		}
		kmm.storeData.sending(n, kmm.dataCon);
		kmm.dataCon.unlockedSend(kmm.storeData,null);
	    } catch (ConnectFailedException cfe) {
		Core.logger.log(this,"Failed to connect to next node (" + cfe.peer + ") to send StoreData message",Logger.MINOR);
	    } catch (SendFailedException sfe) {
		Core.logger.log(this,"Send of StoreData message following finished trailing field failed.",Logger.MINOR);
	    }
	    kmm.state = kmm.DONE;
	    return kmm;
	}

	protected MessageMemory sendFailed(Node n, KeyedMM kmm, 
					   ConduitException ce) {
	    kmm.state = kmm.PENDING;
	    
	    if (ce.inRead()) {
		if (ce.getIOException() 
		    instanceof DataNotValidIOException) {
		    
		    int cb = ((DataNotValidIOException) ce
			      .getIOException()).getCode();

		    Core.logger.log(this,
				    "Insert died on control byte: " + cb,
				    Logger.MINOR);
		} else {
		    Core.logger.log(this,
				    "Error reading from local cache!",
				    Logger.ERROR);
		} 
	    } else {
		// One day the node should be able to find a new place to send
		// the data if this happens!
		Core.logger.log(this,
				"Ouput error sending trailing field",
				Logger.MINOR);
	    }
	    return kmm;
	}

    }

}
